/*******************************************************************************
 * Copyright (c) 2022, MounRiver Studio
 * All rights reserved. This program and the accompanying materials
 * are made available under the terms of the Eclipse Public License v1.0
 * which accompanies this distribution, and is available at
 * http://www.eclipse.org/legal/epl-v10.html
 *
 * Contributors:
 *    MounRiver Studio  - initial API and implementation
 *******************************************************************************/
package convertProjectUtil;

import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.InputStream;

import org.jdom2.Document;
import org.jdom2.Element;
import org.jdom2.input.SAXBuilder;

public class XmlUtil {
private static XmlUtil xmlUtil;
	
	public static XmlUtil getInstance() {
		if(xmlUtil==null) {
			synchronized (XmlUtil.class) {
				xmlUtil=new XmlUtil();
			}
		}
		return xmlUtil;
	}
	
	public String getKeilProjectName(String keilProjectFilePath) throws Exception {
		System.out.println("keilProjectFilePath "+keilProjectFilePath);
		File srcFile=new File(keilProjectFilePath);
		if(!srcFile.exists()) {
			return "";
		}
		SAXBuilder saxBuilder=new SAXBuilder();
		InputStream iStream=new FileInputStream(srcFile);
		Document document=saxBuilder.build(iStream);
		Element rootElement=document.getRootElement();
		if(rootElement!=null) {
			Element element=rootElement.getChild("Targets");
			if(element==null) {
				return "";
			}
			Element element1=element.getChild("Target");
			if(element1==null) {
				return "";
			}
			Element element2=element1.getChild("TargetName");
			if(element2==null) {
				return "";
			}else {
				System.out.println("ProjectName "+element2.getText());
				return element2.getText();
			}
			
		}
		return "";
	}
}
