/*******************************************************************************
 * Copyright (c) 2022, MounRiver Studio
 * All rights reserved. This program and the accompanying materials
 * are made available under the terms of the Eclipse Public License v1.0
 * which accompanies this distribution, and is available at
 * http://www.eclipse.org/legal/epl-v10.html
 *
 * Contributors:
 *    MounRiver Studio  - initial API and implementation
 *******************************************************************************/
package extern;

import java.io.File;

import org.eclipse.core.resources.IProject;
import org.eclipse.core.resources.IWorkspace;
import org.eclipse.core.resources.ResourcesPlugin;

import build.RefreshUtil;

public class AddExternLibraryImp {
	public static void add(String project,String folder,String path)throws Exception {
		System.out.println("project-->"+project); //$NON-NLS-1$
		System.out.println("folder-->"+folder); //$NON-NLS-1$
		System.out.println("path-->"+path); //$NON-NLS-1$
		if(project==null || "".equalsIgnoreCase(project)) { //$NON-NLS-1$
			throw new Exception(Messages.AddExternLibraryImp_4);
		}
		
		IWorkspace workspace = ResourcesPlugin.getWorkspace();
		IProject newProject = workspace.getRoot().getProject(project);
		if(newProject==null || !newProject.exists()) {
			if(project==null || "".equalsIgnoreCase(project)) { //$NON-NLS-1$
				throw new Exception(Messages.AddExternLibraryImp_6);
			}
		}
		//C:/runtime-EclipseApplication/11
		System.out.println(newProject.getLocation().toString());
		String projectPath=newProject.getLocation().toString().replace("/", "\\"); //$NON-NLS-1$ //$NON-NLS-2$
		
		//ⲿڲ
		if(path.startsWith(projectPath)) {
			throw new Exception(Messages.AddExternLibraryImp_9);
		}
		if(!XmlUtil.CheckFolderNameNotExistOnDisk(projectPath,folder)) {
			throw new Exception(Messages.AddExternLibraryImp_0);
		}
		
		
		//check FolerName exist
		if(!XmlUtil.CheckFolderNameNotExist(projectPath+File.separator+".cproject",folder)) { //$NON-NLS-1$
			throw new Exception(Messages.AddExternLibraryImp_13);
		}
		if(!XmlUtil.checkProjectFileNotExist(projectPath+File.separator+".project",folder)) { //$NON-NLS-1$
			throw new Exception(Messages.AddExternLibraryImp_2);
		}
		XmlUtil.modifyCProjectFile(projectPath+File.separator+".cproject", folder); //$NON-NLS-1$
		XmlUtil.modifyProjectFile(projectPath,projectPath+File.separator+".project", folder,path); //$NON-NLS-1$
		
		RefreshUtil.refreshProject(newProject);
	}

}
