/*******************************************************************************
 * Copyright (c) 2022, MounRiver Studio
 * All rights reserved. This program and the accompanying materials
 * are made available under the terms of the Eclipse Public License v1.0
 * which accompanies this distribution, and is available at
 * http://www.eclipse.org/legal/epl-v10.html
 *
 * Contributors:
 *    MounRiver Studio  - initial API and implementation
 *******************************************************************************/
package extern;

import java.io.File;

import org.eclipse.jface.dialogs.IDialogConstants;
import org.eclipse.jface.dialogs.MessageDialog;
import org.eclipse.jface.dialogs.TitleAreaDialog;
import org.eclipse.swt.SWT;
import org.eclipse.swt.events.SelectionAdapter;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.DirectoryDialog;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.swt.widgets.Text;

public class AddExternLinkFolderDialog extends TitleAreaDialog {
	private String title;
	private final String headerTitle;
	private final String message;
	private Text textFolder;
	private Text textLib;
	private File before;
	private String folder;
	private String path;

	public AddExternLinkFolderDialog(Shell parentShell) {
		this(parentShell, Messages.AddExternLinkFolderDialog_0, Messages.AddExternLinkFolderDialog_0,
				Messages.AddExternLinkFolderDialog_1); // $NON-NLS-1$
		setShellStyle(getShellStyle() | SWT.SHEET);
	}

	public AddExternLinkFolderDialog(Shell parentShell, String title, String headerTitle, String message) {
		super(parentShell);
		this.title = title;
		this.headerTitle = headerTitle;
		this.message = message;
		setShellStyle(getShellStyle());
		before = null;
	}

	protected void configureShell(Shell shell) {
		super.configureShell(shell);
		shell.setText(this.title);
//		shell.setSize(550, 255);
	}

	@Override
	protected Control createDialogArea(Composite parent) {
		setTitle(this.headerTitle);
		setMessage(this.message);

		// top level composite
		Composite parentComposite = (Composite) super.createDialogArea(parent);

		// create a composite with standard margins and spacing
		Composite userComp = new Composite(parentComposite, SWT.FILL);
		GridLayout layout = new GridLayout(3, false);

		layout.marginHeight = convertVerticalDLUsToPixels(IDialogConstants.VERTICAL_MARGIN);
		layout.marginWidth = convertHorizontalDLUsToPixels(IDialogConstants.HORIZONTAL_MARGIN);
		layout.verticalSpacing = convertVerticalDLUsToPixels(IDialogConstants.VERTICAL_SPACING);
		layout.horizontalSpacing = convertHorizontalDLUsToPixels(IDialogConstants.HORIZONTAL_SPACING);
		userComp.setLayout(layout);
		GridData gd = new GridData(GridData.FILL_BOTH);
		userComp.setLayoutData(new GridData(GridData.FILL_BOTH));
		userComp.setFont(parentComposite.getFont());

		Label labelFolder = new Label(userComp, SWT.NONE);
		gd = new GridData(GridData.BEGINNING);
		labelFolder.setLayoutData(gd);
		labelFolder.setText(Messages.AddExternLinkFolderDialog_3);

		textFolder = new Text(userComp, SWT.BORDER);
		gd = new GridData(GridData.BEGINNING);
		gd.widthHint = 180;
		textFolder.setLayoutData(gd);

		Label labelEmpty = new Label(userComp, SWT.NONE);
		gd = new GridData(GridData.BEGINNING);
		labelEmpty.setLayoutData(gd);

		Label libFolder = new Label(userComp, SWT.NONE);
		gd = new GridData(GridData.BEGINNING);
		libFolder.setLayoutData(gd);
		libFolder.setText(Messages.AddExternLinkFolderDialog_4);

		textLib = new Text(userComp, SWT.BORDER | SWT.READ_ONLY);
		textLib.setEnabled(false);
		gd = new GridData(GridData.FILL_HORIZONTAL);
		textLib.setLayoutData(gd);

		Button btnBrowse = new Button(userComp, SWT.NONE);
		btnBrowse.setText(Messages.AddExternLinkFolderDialog_5);
		btnBrowse.addSelectionListener(new SelectionAdapter() {
			@Override
			public void widgetSelected(SelectionEvent e) {
				DirectoryDialog directoryDialog = new DirectoryDialog(getShell());
				directoryDialog.setText(""); //$NON-NLS-1$
				directoryDialog.setMessage(""); //$NON-NLS-1$
				String path = directoryDialog.open();
				if (path != null) {
					textLib.setText(path);
					textLib.setToolTipText(path);
					File file = new File(path);
					if (file != null && file.exists() && file.isDirectory()) {
						calculateFolderName(file);
					}
				}
			}
		});
		return userComp;
	}

	@Override
	protected void okPressed() {
		folder = textFolder.getText();
		path = textLib.getText();
		if (folder == null || "".equalsIgnoreCase(folder)) { //$NON-NLS-1$
			showMessageDialog(Messages.AddExternLinkFolderDialog_8);
			return;
		}
		if (path == null || "".equalsIgnoreCase(path)) { //$NON-NLS-1$
			showMessageDialog(Messages.AddExternLinkFolderDialog_10);
			return;
		}
		super.okPressed();
	}

	@Override
	protected void cancelPressed() {
		super.cancelPressed();
	}

	private void calculateFolderName(File file) {
		String nowString = textFolder.getText();
		if ("".equals(nowString) || nowString == null) {
			textFolder.setText(file.getName());
		} else {
			if (textFolder != null && before.getName().equals(nowString)) {
				textFolder.setText(file.getName());
			}
		}
		before = file;
		return;
	}

	private void showMessageDialog(String message) {
		MessageDialog.openWarning(getShell(), Messages.AddExternLinkFolderDialog_12, message);
	}

	public String getFolder() {
		return folder;
	}

	public String getPath() {
		return path;
	}

	/**
	 * Creates the OK and Cancel buttons.
	 */
	@Override
	protected void createButtonsForButtonBar(Composite parent) {
		createButton(parent, IDialogConstants.OK_ID, Messages.AddExternLinkFolderDialog_11, true);
		createButton(parent, IDialogConstants.CANCEL_ID, Messages.AddExternLinkFolderDialog_15, false);
	}
}
