/*******************************************************************************
 * Copyright (c) 2022, MounRiver Studio
 * All rights reserved. This program and the accompanying materials
 * are made available under the terms of the Eclipse Public License v1.0
 * which accompanies this distribution, and is available at
 * http://www.eclipse.org/legal/epl-v10.html
 *
 * Contributors:
 *    MounRiver Studio  - initial API and implementation
 *******************************************************************************/
package extern;

import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.OutputStreamWriter;
import java.util.ArrayList;
import java.util.List;

import org.jdom2.Attribute;
import org.jdom2.Document;
import org.jdom2.Element;
import org.jdom2.input.SAXBuilder;
import org.jdom2.output.Format;
import org.jdom2.output.Format.TextMode;
import org.jdom2.output.XMLOutputter;

import convertProjectUtil.XmlBuildUtil;
import xmlbean.EExcludingEntry;

public class XmlUtil {
	public static void modifyCProjectFile(String path,String folder)throws Exception {
		SAXBuilder sb = new SAXBuilder();
		Document myDoc = null;
		myDoc = sb.build(new FileInputStream(path));
		// Ԫ
		Element root = myDoc.getRootElement();
		
		Element element= getSourceEntriesByRoot(root);
		if(element==null) {
			throw new Exception(Messages.XmlUtil_0);
		}
		///////
		
		//ArrayList<EExcludingEntry> entries=parseFromSourceElement(element);
		
		{
			Element headElement=parseMainEntryFromSourceElement(element);
			if(headElement==null) {
				System.out.println("no main entry"); //$NON-NLS-1$
			} else {
				System.out.println("has main entry"); //$NON-NLS-1$
				String afterString=""; //$NON-NLS-1$
				
				Attribute attribute=headElement.getAttribute("excluding"); //$NON-NLS-1$
				if(attribute==null) {
					afterString=folder;
					
				}else {
					String before=headElement.getAttributeValue("excluding"); //$NON-NLS-1$
					
					if(!before.contains(folder)) {
						if("".equalsIgnoreCase(before)) { //$NON-NLS-1$
							afterString=folder;
						}else {
							afterString=folder+"|"+before; //$NON-NLS-1$
						}
					}else {
						afterString=before;
					}
				}
				
				headElement.setAttribute("excluding", afterString); //$NON-NLS-1$
			}
			
		}
		
		
		Element flag=new Element("entry") //$NON-NLS-1$
				.setAttribute("flags", "VALUE_WORKSPACE_PATH|RESOLVED") //$NON-NLS-1$ //$NON-NLS-2$
				.setAttribute("kind", "sourcePath") //$NON-NLS-1$ //$NON-NLS-2$
				.setAttribute("name", folder); //$NON-NLS-1$
		element.addContent(flag);
		
		Format f = Format.getRawFormat();
        f.setIndent("  ");  //$NON-NLS-1$
        f.setTextMode(TextMode.TRIM_FULL_WHITE);
        XMLOutputter xmlOutput=new XMLOutputter(f,XmlBuildUtil.XMLOUTPUT_CPROJECT_1);
        
        OutputStreamWriter writer = new OutputStreamWriter(new FileOutputStream(path), "UTF-8"); //$NON-NLS-1$
        xmlOutput.output(myDoc, writer);
        writer.close();
		/*String xmlFileData = xmlOutput.outputString(myDoc);
		FileWriter fileWriter = new FileWriter(path);
		fileWriter.write(xmlFileData);
		fileWriter.close();*/
	}
	
	public static boolean checkProjectFileNotExist(String path,String folder)throws Exception {
		SAXBuilder sb = new SAXBuilder();
		Document myDoc = null;
		
		
		myDoc = sb.build(new FileInputStream(path));
		// Ԫ
		Element root = myDoc.getRootElement();
		
		
		return !checkProjectHasFolder(root,folder);
	}
	
	public static void modifyProjectFile(String projectPath,String path,String folder,String folderPath)throws Exception {
		SAXBuilder sb = new SAXBuilder();
		Document myDoc = null;
		
		
		myDoc = sb.build(new FileInputStream(path));
		// Ԫ
		Element root = myDoc.getRootElement();
		
		
		
		
		Element resource=root.getChild("linkedResources"); //$NON-NLS-1$
		if(resource==null) {
			resource=new Element("linkedResources"); //$NON-NLS-1$
			root.addContent(resource);
		}
		
		
		
		Element link=new Element("link"); //$NON-NLS-1$
		
		Element name=new Element("name"); //$NON-NLS-1$
		name.setText(folder);
		
		Element type=new Element("type"); //$NON-NLS-1$
		type.setText("2"); //$NON-NLS-1$
		
		Element location=new Element("location"); //$NON-NLS-1$
		location.setText(caculateRelativePath(projectPath,folderPath).replace("\\", "/")); //$NON-NLS-1$ //$NON-NLS-2$
		
		link.addContent(name);
		link.addContent(type);
		link.addContent(location);
		resource.addContent(link);
		////
		Format f = Format.getRawFormat();
        f.setIndent("  ");  //$NON-NLS-1$
        f.setTextMode(TextMode.TRIM_FULL_WHITE);
        XMLOutputter xmlOutput=new XMLOutputter(f,XmlBuildUtil.XMLOUTPUT_PROJECT);
		
        
        OutputStreamWriter writer = new OutputStreamWriter(new FileOutputStream(path), "UTF-8"); //$NON-NLS-1$
        xmlOutput.output(myDoc, writer);
        writer.close();
		/*String xmlFileData = xmlOutput.outputString(myDoc);
		FileWriter fileWriter = new FileWriter(path);
		
		fileWriter.write(xmlFileData);
		fileWriter.close();*/
	}
	
	private static boolean checkProjectHasFolder(Element root,String folder) throws Exception {
		Element resource=root.getChild("linkedResources"); //$NON-NLS-1$
		if(resource==null) {
			return false;
		}
		List<Element> links=resource.getChildren("link"); //$NON-NLS-1$
		if(links==null || links.size()==0) {
			return false ;
		}
		for(Element e:links) {
			Element e1=e.getChild("name"); //$NON-NLS-1$
			if(e1!=null) {
				if(e1.getText().equals(folder)) {
					return true;
				}
			}
		}
		return false;
	}
	
	private static String caculateRelativePath(String base,String src) throws Exception {
		System.out.println("caculateRelativePath-->"+base+"  "+src); //$NON-NLS-1$ //$NON-NLS-2$
		File bFile=new File(base);
		
		File sFile=new File(src);
		
		if(!bFile.exists() || !bFile.isDirectory() ) {
			throw new Exception(Messages.XmlUtil_26);
		}
		if(!sFile.exists() || !sFile.isDirectory() ) {
			throw new Exception(Messages.XmlUtil_27);
		}
		
		if(src.startsWith(base)) {
			throw new Exception(Messages.XmlUtil_28);
		}
		int count=0;
		boolean flag=true;
		String resultString=""; //$NON-NLS-1$
		while (flag) {
			
			File file=bFile.getParentFile();
			if(file==null) {
				count=-1;
				break;
			}
			count++;
			String bString=file.getAbsolutePath();
			if(src.startsWith(bString)) {
				System.out.println(bString);
				if(bString.endsWith("\\")) {
					System.out.println("Find disk root");
					int i=bString.lastIndexOf("\\");
					bString=bString.substring(0,i);
				}
				
				resultString=src.replace(bString, "PARENT-"+count+"-PROJECT_LOC"); //$NON-NLS-1$ //$NON-NLS-2$
				break;
			}
			bFile=file;
			
		}
		
		if(count==-1) {
			//ͬһ
			System.out.println("not in the same disk"); //$NON-NLS-1$
			return src;
		}
		System.out.println("caculateRelativePath-->"+resultString); //$NON-NLS-1$
		return resultString;
		
	}

	
	public static boolean CheckFolderNameNotExist(String path,String folder) throws Exception {
		System.out.println("CheckFolderNameExist--->"+path+"  "+folder); //$NON-NLS-1$ //$NON-NLS-2$
		SAXBuilder sb = new SAXBuilder();
		Document myDoc = null;
		myDoc = sb.build(new FileInputStream(path));
		// Ԫ
		Element root = myDoc.getRootElement();
		System.out.println(root.getName());

		Element dstElement=getSourceEntriesByRoot(root);
		if(dstElement==null) {
			throw new Exception(Messages.XmlUtil_36);
		}
		System.out.println("Parse xml file succ"); //$NON-NLS-1$
		
		ArrayList<EExcludingEntry> entry=parseFromSourceElement(dstElement);
		
		
		return !hasSourceEntry(entry,folder);
	}
	
	public static boolean CheckFolderNameNotExistOnDisk(String project,String folder) throws Exception {
		File file=new File(project);
		
		if(!file.exists() || !file.isDirectory()) {
			throw new Exception(Messages.XmlUtil_6);
		}
		File[] files=file.listFiles();
		if(files==null || files.length==0) {
			return true;
		}
		
		for (int i = 0; i < files.length; i++) {
			File f = files[i];
			if(f.isDirectory() && f.getName().equals(folder)) {
				return false;
			}
		}
		
		return true;
	}
	
	
	
	private static ArrayList<EExcludingEntry> parseFromSourceElement(Element element) {
		ArrayList<EExcludingEntry> list=new ArrayList<>();
		for (Element e:element.getChildren("entry")) { //$NON-NLS-1$
			EExcludingEntry entry=new EExcludingEntry();
			entry.setExcluding(getAttributeValue(e,"excluding")); //$NON-NLS-1$
			entry.setFlags(getAttributeValue(e,"flags")); //$NON-NLS-1$
			entry.setKind(getAttributeValue(e,"kind")); //$NON-NLS-1$
			entry.setName(getAttributeValue(e,"name")); //$NON-NLS-1$
			list.add(entry);
		}
		return list;
	}
	
	private static String getAttributeValue(Element element,String attr) {
		if(element==null) {
			return null;
		}
		Attribute attribute=element.getAttribute(attr);
		if(attribute==null) {
			return null;
		}
		return attribute.getValue();
	}
	
	private static Element parseMainEntryFromSourceElement(Element element) {
		
		for (Element e:element.getChildren("entry")) { //$NON-NLS-1$
			
			Attribute a1=e.getAttribute("name"); //$NON-NLS-1$
			if(a1!=null && a1.getValue().equals("")) { //$NON-NLS-1$
				return e;
			}
		}
		return null;
	}
	
	private static boolean hasSourceEntry(ArrayList<EExcludingEntry> entry,String name) {
		System.out.println("hasSourceEntry-->"+name); //$NON-NLS-1$
		if(entry==null || entry.size()==0) {
			return false;
		}
		
		for (EExcludingEntry e:entry) {
			if(name.equals(e.getName())) {
				return true;
			}
		}
		return false;
		
	}
	
	
 	private static Element getSourceEntriesByRoot(Element root) {
		
		Element element1=getChild(root,"storageModule","moduleId","org.eclipse.cdt.core.settings"); //$NON-NLS-1$ //$NON-NLS-2$ //$NON-NLS-3$
		if(element1==null) {
			return null;
		}
		
		Element element2=getChild(element1,"cconfiguration","id","ilg.gnumcueclipse.managedbuild.cross.riscv.config.elf.release.1008047074"); //$NON-NLS-1$ //$NON-NLS-2$ //$NON-NLS-3$
		if(element2==null) {
			return null;
		}
		
		Element element3=getChild(element2,"storageModule","moduleId","cdtBuildSystem"); //$NON-NLS-1$ //$NON-NLS-2$ //$NON-NLS-3$
		if(element3==null) {
			return null;
		}
		
		Element element4=getChild(element3,"configuration","parent","ilg.gnumcueclipse.managedbuild.cross.riscv.config.elf.release"); //$NON-NLS-1$ //$NON-NLS-2$ //$NON-NLS-3$
		if(element4==null) {
			return null;
		}
		Element element5=getChild(element4,"sourceEntries","moduleId","cdtBuildSystem"); //$NON-NLS-1$ //$NON-NLS-2$ //$NON-NLS-3$
		if(element5==null) {
			return null;
		}
		return element5;
		
	}
	
	private static Element getChild(Element parent,String tag,String attribute,String value) {
		List<Element> elements=parent.getChildren(tag);
		if(elements==null || elements.size()==0) {
			return null;
		}
		if(elements.size()==1) {
			return elements.get(0);
		}
		for (Element e:elements) {
			Attribute a=e.getAttribute(attribute);
			if(a==null) {
				continue;
			}
			if(value.equalsIgnoreCase(a.getValue())) {
				return e;
			}
		}
		return null;
	}
}
