/*******************************************************************************
 * Copyright (c) 2022, MounRiver Studio
 * All rights reserved. This program and the accompanying materials
 * are made available under the terms of the Eclipse Public License v1.0
 * which accompanies this distribution, and is available at
 * http://www.eclipse.org/legal/epl-v10.html
 *
 * Contributors:
 *    MounRiver Studio  - initial API and implementation
 *******************************************************************************/
package handlers;

import org.eclipse.core.commands.AbstractHandler;
import org.eclipse.core.commands.ExecutionEvent;
import org.eclipse.core.commands.ExecutionException;
import org.eclipse.core.resources.IProject;
import org.eclipse.jface.dialogs.MessageDialog;
import org.eclipse.jface.viewers.ISelection;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.jface.window.Window;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.ui.IWorkbenchPage;
import org.eclipse.ui.IWorkbenchWindow;
import org.eclipse.ui.handlers.HandlerUtil;

import extern.AddExternLibraryImp;
import extern.AddExternLinkFolderDialog;
import extern.Messages;

public class AddExternalLinkFoldHandler extends AbstractHandler {

	private Shell shell;

	@Override
	public Object execute(ExecutionEvent event) throws ExecutionException {
		IProject project = getFirstProject(event);

		if (project != null) {
			showDialog(project);
		}
		return null;
	}

	private IProject getFirstProject(ExecutionEvent event) {
		IWorkbenchWindow window = HandlerUtil.getActiveWorkbenchWindow(event);
		IWorkbenchPage activePage = window.getActivePage();
		shell = activePage.getActivePart().getSite().getShell();
		ISelection selection = activePage.getSelection();
		IStructuredSelection structured = (IStructuredSelection) selection;
		for (Object elem : structured.toList()) {
			IProject project = null;

			if (elem instanceof IProject) {
				project = (IProject) elem;
			}
			if (project != null) {
				System.out.println("projectName-->" + project.getName());
				return project;
			}
		}
		return null;
	}

	private void showDialog(IProject project) {
		if (shell != null) {
			AddExternLinkFolderDialog dialog = new AddExternLinkFolderDialog(shell);
			if (dialog.open() == Window.OK) {
				try {
					AddExternLibraryImp.add(project.getName(), dialog.getFolder(), dialog.getPath());
				} catch (Exception e) {
					e.printStackTrace();
					MessageDialog.openWarning(shell, Messages.AddExternLinkFolderDialog_12, e.getMessage());
				}
			}
		}
	}

}
