package handlers;

import org.eclipse.core.commands.AbstractHandler;
import org.eclipse.core.commands.ExecutionEvent;
import org.eclipse.core.commands.ExecutionException;
import org.eclipse.core.runtime.Platform;
import org.eclipse.jface.dialogs.MessageDialog;
import org.eclipse.jface.util.Util;
import org.eclipse.ui.IWorkbenchWindow;
import org.eclipse.ui.PlatformUI;

import convert.ConvertKeilProjectDialog;

public class ConvertKeilHandler extends AbstractHandler {

	@Override
	public Object execute(ExecutionEvent arg0) throws ExecutionException {
		IWorkbenchWindow fWindow = PlatformUI.getWorkbench().getActiveWorkbenchWindow();
		if (Util.isWindows()) {
			ConvertKeilProjectDialog dialog = new ConvertKeilProjectDialog(fWindow.getShell());
			dialog.open();
		} else {
			MessageDialog.openWarning(fWindow.getShell(), Messages.ConvertKeilHandler_0,
					Platform.getOS() + Messages.ConvertKeilHandler_1);
		}
		return null;
	}
}
