/*******************************************************************************
 * Copyright (c) 2022, MounRiver Studio
 * All rights reserved. This program and the accompanying materials
 * are made available under the terms of the Eclipse Public License v1.0
 * which accompanies this distribution, and is available at
 * http://www.eclipse.org/legal/epl-v10.html
 *
 * Contributors:
 *    MounRiver Studio  - initial API and implementation
 *******************************************************************************/
package handlers.vendor;

import org.eclipse.cdt.core.model.ICElement;
import org.eclipse.cdt.core.model.ICProject;
import org.eclipse.cdt.internal.ui.cview.IncludeRefContainer;
import org.eclipse.cdt.internal.ui.cview.IncludeReferenceProxy;
import org.eclipse.core.commands.AbstractHandler;
import org.eclipse.core.commands.ExecutionEvent;
import org.eclipse.core.commands.ExecutionException;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.resources.IResource;
import org.eclipse.core.runtime.Adapters;
import org.eclipse.jface.dialogs.MessageDialog;
import org.eclipse.jface.viewers.TreeSelection;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.ui.IEditorPart;
import org.eclipse.ui.IWorkbenchPart;
import org.eclipse.ui.IWorkbenchWindow;
import org.eclipse.ui.PlatformUI;
import org.eclipse.ui.handlers.HandlerUtil;
import org.eclipse.ui.internal.dialogs.PropertyDialog;
import org.eclipse.ui.internal.navigator.NavigatorContentService;
import org.eclipse.ui.navigator.CommonViewer;
import org.eclipse.ui.navigator.INavigatorContentService;
import org.eclipse.ui.navigator.resources.ProjectExplorer;

@SuppressWarnings("restriction")
public class SelectDebuggerHandler extends AbstractHandler {
	protected IProject project;

	@Override
	public Object execute(ExecutionEvent event) throws ExecutionException {
		Shell shell = HandlerUtil.getActiveShell(event);
		project = getSelectionProject();

		if (project == null) {
			// no project can be found
			MessageDialog.openWarning(shell, Messages.ProjectBuildSettingMenuDelegate_2,
					Messages.ProjectBuildSettingMenuDelegate_3);
			return null;
		}

		String propertyPageId = "com.mounriver.project.debuggerPage";//$NON-NLS-1$
		PropertyDialog dialog = PropertyDialog.createDialogOn(shell, propertyPageId, project);
		if (dialog != null)
			dialog.open();

		return null;
	}

	protected IProject getSelectionProject() {
		IWorkbenchWindow window = PlatformUI.getWorkbench().getActiveWorkbenchWindow();
		if (window != null) {
			IWorkbenchPart part = window.getActivePage().findView(ProjectExplorer.VIEW_ID);
			if (part != null) {
				NavigatorContentService contentService = (NavigatorContentService) Adapters.adapt(part,
						INavigatorContentService.class);
				if (contentService != null) {
					CommonViewer viewer = (CommonViewer) contentService.getViewer();
					Object selection = viewer.getSelection();
					if (selection instanceof TreeSelection) {
						TreeSelection treeSelection = (TreeSelection) selection;
						Object element = treeSelection.getFirstElement();
						if (element instanceof IResource) {
							return ((IResource) element).getProject();
						} else if (element instanceof ICElement) {
							ICProject cProject = ((ICElement) element).getCProject();
							return cProject.getProject();
						} else if (element instanceof IEditorPart) {
							IFile file = (IFile) (((IEditorPart) element).getEditorInput().getAdapter(IFile.class));
							return file.getProject();
						} else if (element instanceof IncludeRefContainer) {
							IncludeRefContainer includeRefContainer = (IncludeRefContainer) element;
							return includeRefContainer.getAdapter(ICProject.class).getProject();
						} else if (element instanceof IncludeReferenceProxy) {
							IncludeReferenceProxy icIncludeReferenceProxy = (IncludeReferenceProxy) element;
							return icIncludeReferenceProxy.getIncludeRefContainer().getAdapter(ICProject.class)
									.getProject();
						}
					}
				}
			}
		}
		return null;
	}
}
