/*******************************************************************************
 * Copyright (c) 2022, MounRiver Studio
 * All rights reserved. This program and the accompanying materials
 * are made available under the terms of the Eclipse Public License v1.0
 * which accompanies this distribution, and is available at
 * http://www.eclipse.org/legal/epl-v10.html
 *
 * Contributors:
 *    MounRiver Studio  - initial API and implementation
 *******************************************************************************/
package importDialog;

import org.eclipse.core.runtime.Platform;
import org.eclipse.jface.dialogs.Dialog;
import org.eclipse.jface.dialogs.IDialogConstants;
import org.eclipse.jface.dialogs.MessageDialog;
import org.eclipse.jface.dialogs.TitleAreaDialog;
import org.eclipse.swt.SWT;
import org.eclipse.swt.events.SelectionAdapter;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.FileDialog;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.swt.widgets.Text;

@SuppressWarnings("restriction")
public class LoadDialog extends TitleAreaDialog {
	private String title;
	private final String headerTitle;
	private final String message;
	private String filePath = ""; //$NON-NLS-1$

	private boolean bLoadSln = true;
	private Label label;
	private Text text;
	private Button btnBrowse;
	private Button btnRadioSln;
	private Button btnRadioPrj;

	public LoadDialog(Shell parentShell) {
		this(parentShell, Messages.NewImportDialog_0, Messages.NewImportDialog_0, Messages.NewImportDialog_6); // $NON-NLS-1$
		setShellStyle(getShellStyle() | SWT.SHEET);
	}

	public LoadDialog(Shell parentShell, String title, String headerTitle, String message) {
		super(parentShell);
		this.title = title;
		this.headerTitle = headerTitle;
		this.message = message;
	}

	protected void configureShell(Shell shell) {
		super.configureShell(shell);
		shell.setText(this.title);
//		shell.setSize(1133, 880);
	}

	@Override
	protected Control createDialogArea(Composite parent) {
		setTitle(this.headerTitle);
		setMessage(this.message);

		// top level composite
		Composite parentComposite = (Composite) super.createDialogArea(parent);

		// create a composite with standard margins and spacing
		Composite userComp = new Composite(parentComposite, SWT.FILL);
		GridLayout layout = new GridLayout(3, false);
		
		layout.marginHeight = convertVerticalDLUsToPixels(IDialogConstants.VERTICAL_MARGIN);
		layout.marginWidth = convertHorizontalDLUsToPixels(IDialogConstants.HORIZONTAL_MARGIN);
		layout.verticalSpacing = convertVerticalDLUsToPixels(IDialogConstants.VERTICAL_SPACING);
		layout.horizontalSpacing = convertHorizontalDLUsToPixels(IDialogConstants.HORIZONTAL_SPACING);
		userComp.setLayout(layout);
		userComp.setLayoutData(new GridData(GridData.FILL_BOTH));
		userComp.setFont(parentComposite.getFont());

		Composite compRadio = new Composite(userComp, SWT.NONE);
		GridData gd = new GridData(GridData.FILL_HORIZONTAL);
		gd.horizontalSpan = 3;
		compRadio.setLayoutData(gd);
		compRadio.setLayout(new GridLayout(2, true));

		btnRadioPrj = new Button(compRadio, SWT.RADIO);
		gd = new GridData(GridData.BEGINNING);
		btnRadioPrj.setLayoutData(gd);
		btnRadioPrj.addSelectionListener(new SelectionAdapter() {
			@Override
			public void widgetSelected(SelectionEvent e) {
				bLoadSln = !btnRadioPrj.getSelection();
				setMessage(Messages.NewImportDialog_6);
				updateControls();
			}
		});
		btnRadioPrj.setText(Messages.LoadDialog_2);
		
		btnRadioSln = new Button(compRadio, SWT.RADIO);
		gd = new GridData(GridData.BEGINNING);
		btnRadioSln.setLayoutData(gd);
		btnRadioSln.addSelectionListener(new SelectionAdapter() {
			@Override
			public void widgetSelected(SelectionEvent e) {
				bLoadSln = btnRadioSln.getSelection();
				setMessage(Messages.NewImportDialog_61);
				updateControls();
			}
		});
		btnRadioSln.setText(Messages.LoadDialog_1);
		
		// disable this button because "load.exe" not enabled
		if (Platform.getOS().equals(Platform.OS_LINUX) || System.getProperty("eclipse.launcher").endsWith("_Community.exe")) {
			btnRadioSln.setEnabled(false);
		}
		
		label = new Label(userComp, SWT.NONE);
		gd = new GridData(GridData.BEGINNING);
		label.setLayoutData(gd);
		label.setText(Messages.NewImportDialog_5);

		text = new Text(userComp, SWT.BORDER | SWT.READ_ONLY);
		gd = new GridData(GridData.FILL_HORIZONTAL);
		text.setLayoutData(gd);

		btnBrowse = new Button(userComp, SWT.PUSH);
		btnBrowse.setText(Messages.NewImportDialog_1);
		gd = new GridData(GridData.BEGINNING);
		btnBrowse.setLayoutData(gd);

		btnBrowse.addSelectionListener(new SelectionAdapter() {
			@Override
			public void widgetSelected(SelectionEvent e) {
				FileDialog fileDialog = new FileDialog(getShell(), SWT.OPEN);
				fileDialog.setText(Messages.NewImportDialog_11);
				fileDialog.setFilterNames(
						new String[] { bLoadSln ? Messages.LoadDialog_3 : Messages.LoadDialog_4 });
				fileDialog.setFilterExtensions(new String[] { bLoadSln ? "*.wvsln" : "*.wvproj;*.project" }); //$NON-NLS-1$ //$NON-NLS-2$
				String path = fileDialog.open();
				if (path != null) {
					text.setText(path);
					text.setToolTipText(path);
				}
			}
		});

//		String str = Platform.getInstallLocation().getURL().getFile() + "plugins" + File.separator
//				+ "com.mounriver.welcome_1.0.0.v20200609" + File.separator + "content" + File.separator + "index.xhtml";
//		System.setProperty("org.eclipse.swt.browser.XULRunnerPath", "C:/MounRiver/MounRiver_Studio/xulrunner-sdk");
//		Browser browser = new Browser(userComp, SWT.WEBKIT);
//		GridData gd = new GridData(GridData.FILL_BOTH);
//		gd.horizontalSpan = 3;
//		browser.setLayoutData(gd);
//		browser.setUrl(str);
//		String browserType = browser.getBrowserType();
//		setTitle(browserType);
//		setMessage(browserType);
		
		setHelpAvailable(false);
		Dialog.applyDialogFont(parentComposite);
		return parentComposite;
	}

	protected void updateControls() {
		text.setText("");
		if(bLoadSln) {
			btnRadioSln.setSelection(true);
			btnRadioPrj.setSelection(false);
		} else {
			btnRadioSln.setSelection(false);
			btnRadioPrj.setSelection(true);
		}
	}
	

	@Override
	protected void okPressed() {
		if (text.getText().equals("")) { //$NON-NLS-1$
			MessageDialog.openWarning(getShell(), Messages.NewImportDialog_8, Messages.NewImportDialog_9);
			return;
		} else {
			filePath = text.getText();
		}
		super.okPressed();
	}

	public String getFilePath() {
		return filePath;
	}
	
	@Override
	public void setMessage(String newMessage) {
		super.setMessage(newMessage);
	}
}
