/*******************************************************************************
 * Copyright (c) 2022, MounRiver Studio
 * All rights reserved. This program and the accompanying materials
 * are made available under the terms of the Eclipse Public License v1.0
 * which accompanies this distribution, and is available at
 * http://www.eclipse.org/legal/epl-v10.html
 *
 * Contributors:
 *    MounRiver Studio  - initial API and implementation
 *******************************************************************************/
package intro;

import org.eclipse.cdt.internal.ui.wizards.CWizardRegistry;
import org.eclipse.debug.ui.IDebugUIConstants;
import org.eclipse.ui.IFolderLayout;
import org.eclipse.ui.IPageLayout;
import org.eclipse.ui.IPerspectiveFactory;

@SuppressWarnings("restriction")
public class IntroPerspectives implements IPerspectiveFactory {
	public void createInitialLayout(IPageLayout layout) {
		String editorArea = layout.getEditorArea();
		
		IFolderLayout topLeft = layout.createFolder("topLeft", IPageLayout.LEFT, 0.2F, editorArea);		
		topLeft.addView("org.eclipse.ui.navigator.ProjectExplorer");
		topLeft.addPlaceholder("org.eclipse.cdt.ui.CView");
//		topLeft.addPlaceholder("org.eclipse.ui.views.ResourceNavigator");

		IFolderLayout bottomLeft = layout.createFolder("bottomLeft", IPageLayout.BOTTOM, 0.67F, "topLeft");
		bottomLeft.addView("org.eclipse.ui.views.ContentOutline");
		bottomLeft.addView("org.eclipse.team.ui.GenericHistoryView");
		bottomLeft.addView("org.eclipse.ui.views.BookmarkView");

		IFolderLayout bottomRight = layout.createFolder("bottomRight", IPageLayout.BOTTOM, 0.67F, editorArea);
		bottomRight.addView("org.eclipse.ui.views.PropertySheet");
		bottomRight.addView("org.eclipse.ui.views.ProblemView");
//		bottomRight.addView("org.eclipse.ui.views.TaskList");
		bottomRight.addView("org.eclipse.ui.console.ConsoleView");
		bottomRight.addView("org.eclipse.search.ui.views.SearchView");
		bottomRight.addView(IDebugUIConstants.ID_BREAKPOINT_VIEW);
		
		IFolderLayout topRight = layout.createFolder("topRight", IPageLayout.RIGHT, 0.8F, editorArea);
		topRight.addPlaceholder("org.eclipse.ui.views.BookmarkView");
		topRight.addPlaceholder("org.eclipse.ui.browser.view");
		
		layout.addShowViewShortcut(IPageLayout.ID_PROJECT_EXPLORER);
		layout.addShowViewShortcut("org.eclipse.search.ui.views.SearchView");
		layout.addShowViewShortcut("org.eclipse.ui.console.ConsoleView");
		layout.addShowViewShortcut("org.eclipse.ui.views.ContentOutline");
		layout.addShowViewShortcut("org.eclipse.ui.views.ProblemView");
		layout.addShowViewShortcut("org.eclipse.team.ui.GenericHistoryView");
//		layout.addShowViewShortcut("org.eclipse.cdt.ui.CView");
		layout.addShowViewShortcut("org.eclipse.ui.views.ResourceNavigator");
		layout.addShowViewShortcut(IDebugUIConstants.ID_BREAKPOINT_VIEW);
		layout.addShowViewShortcut(IPageLayout.ID_OUTLINE);
		
		addCWizardShortcuts(layout);
	}

	
	private void addCWizardShortcuts(IPageLayout layout) {
		String[] wizIDs = CWizardRegistry.getProjectWizardIDs();
		for (int i = 0; i < wizIDs.length; i++) {
			if ((!wizIDs[i].endsWith(".NewCWizard1")) && (!wizIDs[i].endsWith(".NewCWizard2"))) {
				layout.addNewWizardShortcut(wizIDs[i]);
			}
		}
		wizIDs = CWizardRegistry.getFolderWizardIDs();
		for (int i = 0; i < wizIDs.length; i++) {
			layout.addNewWizardShortcut(wizIDs[i]);
		}
		wizIDs = CWizardRegistry.getFileWizardIDs();
		for (int i = 0; i < wizIDs.length; i++) {
			layout.addNewWizardShortcut(wizIDs[i]);
		}
		wizIDs = CWizardRegistry.getTypeWizardIDs();
		for (int i = 0; i < wizIDs.length; i++) {
			layout.addNewWizardShortcut(wizIDs[i]);
		}
		// Add MounRiver wizard shortcut
		layout.addNewWizardShortcut("mrs.wizard.project");
	}
}
