/*******************************************************************************
 * Copyright (c) 2022, MounRiver Studio
 * All rights reserved. This program and the accompanying materials
 * are made available under the terms of the Eclipse Public License v1.0
 * which accompanies this distribution, and is available at
 * http://www.eclipse.org/legal/epl-v10.html
 *
 * Contributors:
 *    MounRiver Studio  - initial API and implementation
 *******************************************************************************/
package intro;

import java.io.File;
import java.util.Properties;

import org.eclipse.core.runtime.NullProgressMonitor;
import org.eclipse.jface.dialogs.MessageDialog;
import org.eclipse.jface.window.Window;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.ui.PlatformUI;
import org.eclipse.ui.internal.intro.impl.IntroPlugin;
import org.eclipse.ui.intro.IIntroSite;
import org.eclipse.ui.intro.config.IIntroAction;

import importDialog.LoadDialog;
import importDialog.Messages;
import importOperation.ImportUtil;
import menuAction.LoadAction;

@SuppressWarnings("restriction")
public class LoadSlnOrProjAction implements IIntroAction {
	@Override
	public void run(IIntroSite site, Properties params) {
		Shell shell = PlatformUI.getWorkbench().getActiveWorkbenchWindow().getShell();
		LoadDialog dialog = new LoadDialog(shell);
		if (dialog.open() == Window.OK) {
			try {
				File file = new File(dialog.getFilePath());
				if (file.getName().endsWith(".wvsln")) {
					LoadAction.changeSolution(file);
				} 
				else if (file.getName().endsWith(".wvproj") || file.getName().endsWith(".project")) {
					ImportUtil.importProjectFromFolder(file.getParentFile().getAbsolutePath(),
							new NullProgressMonitor(), null);
				}

			} catch (Exception e1) {
				e1.printStackTrace();
				MessageDialog.openError(shell, Messages.NewImportDialog_10, e1.getMessage());
			}
		}
		IntroPlugin.closeIntro();
	}
}