/*******************************************************************************
 * Copyright (c) 2022, MounRiver Studio
 * All rights reserved. This program and the accompanying materials
 * are made available under the terms of the Eclipse Public License v1.0
 * which accompanies this distribution, and is available at
 * http://www.eclipse.org/legal/epl-v10.html
 *
 * Contributors:
 *    MounRiver Studio  - initial API and implementation
 *******************************************************************************/
package intro;

import java.util.Properties;

import org.eclipse.jface.viewers.StructuredSelection;
import org.eclipse.jface.wizard.WizardDialog;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.ui.PlatformUI;
import org.eclipse.ui.internal.intro.impl.IntroPlugin;
import org.eclipse.ui.intro.IIntroSite;
import org.eclipse.ui.intro.config.IIntroAction;

import wizard.NewProjectWizard;

@SuppressWarnings("restriction")
public class NewMounRiverProjectAction implements IIntroAction {

	@Override
	public void run(IIntroSite arg0, Properties arg1) {
		Shell shell = PlatformUI.getWorkbench().getActiveWorkbenchWindow().getShell();
		NewProjectWizard newWizard = new NewProjectWizard();

		newWizard.init(PlatformUI.getWorkbench(), StructuredSelection.EMPTY);
		newWizard.setNeedsProgressMonitor(true);
		
		WizardDialog dialog = new WizardDialog(shell,
				newWizard);
		dialog.create();
		dialog.open();
		IntroPlugin.closeIntro();
	}
}
