/*******************************************************************************
 * Copyright (c) 2022, MounRiver Studio
 * All rights reserved. This program and the accompanying materials
 * are made available under the terms of the Eclipse Public License v1.0
 * which accompanies this distribution, and is available at
 * http://www.eclipse.org/legal/epl-v10.html
 *
 * Contributors:
 *    MounRiver Studio  - initial API and implementation
 *******************************************************************************/
package intro;

import java.net.URL;
import java.util.Properties;

import org.eclipse.help.internal.server.WebappManager;
import org.eclipse.ui.PlatformUI;
import org.eclipse.ui.browser.IWorkbenchBrowserSupport;
import org.eclipse.ui.internal.intro.impl.IntroPlugin;
import org.eclipse.ui.intro.IIntroSite;
import org.eclipse.ui.intro.config.IIntroAction;

public class OpenHelpPDFAction implements IIntroAction {

	@Override
	public void run(IIntroSite site, Properties params) {
		openHelp();
	}

	@SuppressWarnings("restriction")
	public static void openHelp() {
		IWorkbenchBrowserSupport support = PlatformUI.getWorkbench().getBrowserSupport();
		boolean isZh = System.getProperty("osgi.nl").equals("zh_CN");
		try {
			WebappManager.start("help"); //$NON-NLS-1$
			String url = null;
			if (isZh) {
				url = "http://" + WebappManager.getHost() + ":" + WebappManager.getPort() + "/help/"
						+ "index.jsp?topic=%2Fcom.mounriver.doc.user%2FMounRiver_Help_V160%2FWelcome%2520to%2520MounRiver.htm&cp=2_0";
			} else {
				url = "http://" + WebappManager.getHost() + ":" + WebappManager.getPort() + "/help/"
						+ "index.jsp?topic=%2Fcom.mounriver.doc.user%2FMounRiver_Help_V160_En%2FWelcome%2520to%2520MounRiver.htm&cp=0_0";
			}
			support.createBrowser(IWorkbenchBrowserSupport.LOCATION_BAR | IWorkbenchBrowserSupport.NAVIGATION_BAR,
					"org.eclipse.ui.browser", null, null).openURL(new URL(url));
			IntroPlugin.closeIntro();
//			IntroPlugin.setIntroStandby(true);
		} catch (Exception e) {
			e.printStackTrace();
		}

	}

}
