/*******************************************************************************
 * Copyright (c) 2022, MounRiver Studio
 * All rights reserved. This program and the accompanying materials
 * are made available under the terms of the Eclipse Public License v1.0
 * which accompanies this distribution, and is available at
 * http://www.eclipse.org/legal/epl-v10.html
 *
 * Contributors:
 *    MounRiver Studio  - initial API and implementation
 *******************************************************************************/
package menuAction;

import java.io.File;

import org.eclipse.core.runtime.NullProgressMonitor;
import org.eclipse.jface.action.IAction;
import org.eclipse.jface.dialogs.MessageDialog;
import org.eclipse.jface.viewers.ISelection;
import org.eclipse.jface.window.Window;
import org.eclipse.ui.IWorkbenchWindow;
import org.eclipse.ui.IWorkbenchWindowActionDelegate;

import importDialog.LoadDialog;
import importDialog.Messages;
import importOperation.ImportUtil;

public class LoadAction implements IWorkbenchWindowActionDelegate {
	private static final String NEWLINE = System.getProperty("line.separator", "\n"); //$NON-NLS-1$ //$NON-NLS-2$
	private IWorkbenchWindow myWindow;

	@Override
	public void run(IAction arg0) {
		LoadDialog dialog = new LoadDialog(myWindow.getShell());
		if (dialog.open() == Window.OK) {
			File file = new File(dialog.getFilePath());
			try {
				if (file.getName().endsWith(".wvsln")) {
					changeSolution(file);
				} else if (file.getName().endsWith(".wvproj") || file.getName().endsWith(".project")) {
					ImportUtil.importProjectFromFolder(file.getParentFile().getAbsolutePath(),
							new NullProgressMonitor(), null);
				}
			} catch (Exception e) {
				e.printStackTrace();
				MessageDialog.openError(myWindow.getShell(), Messages.NewImportDialog_10, e.getMessage());
			}
		}
	}

	@Override
	public void selectionChanged(IAction arg0, ISelection arg1) {
		// TODO Auto-generated method stub

	}

	@Override
	public void dispose() {
		// TODO Auto-generated method stub

	}

	@Override
	public void init(IWorkbenchWindow arg0) {
		myWindow = arg0;
	}

	public static void changeSolution(File saveFile) throws Exception {
		String command = "cmd /c \"" + saveFile.getAbsolutePath() + "\""; //$NON-NLS-1$
		Runtime.getRuntime().exec(command);
	}
}
