/*******************************************************************************
 * Copyright (c) 2022, MounRiver Studio
 * All rights reserved. This program and the accompanying materials
 * are made available under the terms of the Eclipse Public License v1.0
 * which accompanies this distribution, and is available at
 * http://www.eclipse.org/legal/epl-v10.html
 *
 * Contributors:
 *    MounRiver Studio  - initial API and implementation
 *******************************************************************************/
package mrsdebugger;

import java.util.ArrayList;

public class MRSComponent {
	private String vendor;
	private ArrayList<MCU> mcuList;

	private String openocdVendor;
	private String openocdExeName;

	private String armGdbVendor;
	private String armGdbName;

	private String riscvGdbVendor;
	private String riscvGdbName;

	// private String svdPath;

	public MRSComponent(String vendor, ArrayList<MCU> mcuList) {
		super();
		this.vendor = vendor;
		this.mcuList = mcuList;
	}

	public String getVendor() {
		return vendor;
	}

	public void setVendor(String vendor) {
		this.vendor = vendor;
	}

	public ArrayList<MCU> getMcuList() {
		return mcuList;
	}

	public void setMcuList(ArrayList<MCU> mcuList) {
		this.mcuList = mcuList;
	}

	public String getOpenocdExeName() {
		return openocdExeName;
	}

	public void setOpenocdExeName(String openocdExeName) {
		this.openocdExeName = openocdExeName;
	}

	public String getArmGdbName() {
		return armGdbName;
	}

	public void setArmGdbName(String armGdbName) {
		this.armGdbName = armGdbName;
	}

	public String getRiscvGdbName() {
		return riscvGdbName;
	}

	public void setRiscvGdbName(String riscvGdbName) {
		this.riscvGdbName = riscvGdbName;
	}

	public String getOpenocdVendor() {
		return openocdVendor;
	}

	public void setOpenocdVendor(String openocdVendor) {
		this.openocdVendor = openocdVendor;
	}

	public String getArmGdbVendor() {
		return armGdbVendor;
	}

	public void setArmGdbVendor(String armGdbVendor) {
		this.armGdbVendor = armGdbVendor;
	}

	public String getRiscvGdbVendor() {
		return riscvGdbVendor;
	}

	public void setRiscvGdbVendor(String riscvGdbVendor) {
		this.riscvGdbVendor = riscvGdbVendor;
	}
}
