package net;
import java.io.IOException;
import java.util.concurrent.TimeUnit;

import okhttp3.Call;
import okhttp3.HttpUrl;
import okhttp3.OkHttpClient;
import okhttp3.Request;

public class NetClient {
	private static volatile NetClient uploadClient;
	private OkHttpClient client;	
	
	public static NetClient getInstance() {
		if(uploadClient==null) {
			synchronized (NetClient.class) {
				uploadClient=new NetClient();
			}
		}
		return uploadClient;
	}
	
	public NetClient() {
		client=new OkHttpClient.Builder()
				.connectTimeout(15, TimeUnit.SECONDS)
				.writeTimeout(20, TimeUnit.SECONDS)
				.readTimeout(20,TimeUnit.SECONDS)
				.addInterceptor(new RetryIntercepter())
				.build();
	}
	
	public void uploadUser(RequestBean requestBean) throws IOException {
		HttpUrl.Builder uBuilder = HttpUrl.parse(RetryIntercepter.EXAMPLE_URL).newBuilder();
		
		uBuilder.addQueryParameter("uid", requestBean.getUid());
		uBuilder.addQueryParameter("osVersion", requestBean.osVersion);
		uBuilder.addQueryParameter("osType", requestBean.osType);
		

		final Request request = new Request.Builder().url(uBuilder.build()).tag(RetryIntercepter.TAG_UPLOAD_USER).get().build();
		Call call = client.newCall(request);
		call.execute();
	}
	
	private void cancel(String TAG) {
		
		for(Call call:client.dispatcher().runningCalls()) {
			if(call.request().tag().equals(TAG)) {
				call.cancel();
			}
		}
		
	}
	public void cancel() {
		for(Call call:client.dispatcher().runningCalls()) {
			call.cancel();
		}
	}
	
}
