package net;


import java.io.IOException;

import common.LogUtil;
import okhttp3.HttpUrl;
import okhttp3.Interceptor;
import okhttp3.Request;
import okhttp3.Response;
import okhttp3.Interceptor.Chain;

public class RetryIntercepter implements Interceptor {
	
	public static final String TAG_UPLOAD_USER="TAG_UPLOAD_USER";
	
	
	
	private static final String PUBLIC_URL_HOST="http://api.mounriver.com";
	
	public static final String PUBLIC_UPLOAD_USER=PUBLIC_URL_HOST+"/mountriver/api/upgrade/updateCInfo"; //$NON-NLS-1$

	
	//http://192.168.111.198:168/
	//http://192.168.111.93:9099/
	//http://192.168.1.166:9099/
	private static final String PRIVATE_URL_HOST="http://192.168.111.198:168";
	
	public static final String PRIVATE_UPLOAD_USER=PRIVATE_URL_HOST+"/mountriver/api/upgrade/updateCInfo"; //$NON-NLS-1$

	public static final String EXAMPLE_URL="http://api.mounriver.com/mountriver/api";
	
	
	private static NetType netType=NetType.Intranet;
	@Override
	public Response intercept(Chain chain) throws IOException {
		// TODO Auto-generated method stub
		String tag=(String) chain.request().tag();
		return interceptProceedRetry(tag, chain,chain.request());
	}
	
	public static void setNetType(NetType type) {
		
		netType=type;
		LogUtil.d("set network type:"+type.toString());
	}
	
	private Response interceptProceedRetry(String tag,Chain chain,Request request) throws IOException{
		LogUtil.d("current network type:"+netType.toString());
		if (TAG_UPLOAD_USER.equals(tag)) {
			if(netType==NetType.Extranet) {
				return beforeProceedRetry(tag,chain,request,PUBLIC_UPLOAD_USER,PRIVATE_UPLOAD_USER);
			}else {
				return beforeProceedRetry(tag,chain,request,PRIVATE_UPLOAD_USER,PUBLIC_UPLOAD_USER);
			}
		}
		return proceed(chain,chain.request());
	}

	private Response beforeProceedRetry(String tag,Chain chain,Request request,String firstUrl,String secondUrl)throws IOException {
		
		Response response=proceedRetry(chain,request,firstUrl,secondUrl);
		if(response!=null && response.isSuccessful() && (TAG_UPLOAD_USER.equals(tag))) {
			//ж
			String url=response.request().url().toString();
			LogUtil.d("ж͵Ӧɹ,urlǣ"+url);
			if(url!=null) {
				if(url.startsWith("http://192.168")) {
					setNetType(NetType.Intranet);
				}else if (url.startsWith("http://api.mounriver.com")) {
					setNetType(NetType.Extranet);
				}
			}
		}
		
		return response;
	}
	
	
	
	private Response proceed(Chain chain,Request request) throws IOException {
		LogUtil.d("request:"+request.toString());
		return chain.proceed(request);
	}
	
	private Response proceedRetry(Chain chain,Request request,String firstUrl,String secondUrl) throws IOException {
		
		int querySize =request.url().querySize();
		
		HttpUrl.Builder builder1=request.url().newBuilder(firstUrl);
		HttpUrl.Builder builder2=request.url().newBuilder(secondUrl);
		for (int i = 0; i < querySize; i++) {
			String queryName=request.url().queryParameterName(i);
			String queryValue=request.url().queryParameterValue(i);
			builder1.addQueryParameter(queryName, queryValue);
			builder2.addQueryParameter(queryName, queryValue);
		}
		
		
		Request r=request.newBuilder().url(builder1.build()).build();
		LogUtil.d("request:"+r.toString());
		Response response=null;
		try {
			response = chain.proceed(r);
		} catch (IOException e) {
			// TODO Auto-generated catch block
			LogUtil.d("first request fail: "+e.getMessage());
		}
		if(response==null || !response.isSuccessful()) {
			LogUtil.d("retry another Url");
			Request request1=request.newBuilder().url(builder2.build()).build();
			LogUtil.d("request:"+request1.toString());
			response=chain.proceed(request1);
		}
		return response;
	}
	
	public static enum NetType{
		
		Extranet(""),
		Intranet("");
		private String desString;

		private NetType(String desString) {
			this.desString = desString;
		}

		@Override
		public String toString() {
			// TODO Auto-generated method stub
			return desString;
		}

	}
}
	
