/*******************************************************************************
 * Copyright (c) 2022, MounRiver Studio
 * All rights reserved. This program and the accompanying materials
 * are made available under the terms of the Eclipse Public License v1.0
 * which accompanies this distribution, and is available at
 * http://www.eclipse.org/legal/epl-v10.html
 *
 * Contributors:
 *    MounRiver Studio  - initial API and implementation
 *******************************************************************************/
package systemConfig;

import java.util.HashMap;

public class Config {
	private String name;
	private String value;
	private String[] valueArr;
	private boolean onlyDefine;
	private static HashMap<String, String> mapConfigNameDisplay = new HashMap<String, String>();
	
	static {
		//Mapping between Macro and display name. Offered by hardware. 
		mapConfigNameDisplay.put("RT_NAME_MAX", "max name");
		mapConfigNameDisplay.put("RT_ALIGN_SIZE", "alignsize");
		mapConfigNameDisplay.put("RT_USING_HOOK", "usinghook");
		mapConfigNameDisplay.put("RT_USING_IDLE_HOOK", "usingidlehook");
	}

	public Config(String name, String value, String[] valueArr, boolean onlyDefine) {
		super();
		this.name = name;
		this.value = value;
		this.valueArr = valueArr;
		this.onlyDefine = onlyDefine;
	}
	
	public String getName() {
		return name;
	}
	public void setName(String name) {
		this.name = name;
	}
	public String getValue() {
		return value;
	}
	public void setValue(String value) {
		this.value = value;
	}

	public String[] getValueArr() {
		return valueArr;
	}

	public void setValueArr(String[] valueArr) {
		this.valueArr = valueArr;
	}

	public boolean isOnlyDefine() {
		return onlyDefine;
	}

	public void setOnlyDefine(boolean onlyDefine) {
		this.onlyDefine = onlyDefine;
	}
	
	public static HashMap<String, String> getConfigNameDisplayMap() {
		return mapConfigNameDisplay;
	}
}
