/*******************************************************************************
 * Copyright (c) 2022, MounRiver Studio
 * All rights reserved. This program and the accompanying materials
 * are made available under the terms of the Eclipse Public License v1.0
 * which accompanies this distribution, and is available at
 * http://www.eclipse.org/legal/epl-v10.html
 *
 * Contributors:
 *    MounRiver Studio  - initial API and implementation
 *******************************************************************************/
package systemConfig;

import java.io.BufferedReader;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.util.ArrayList;

import org.eclipse.core.resources.IStorage;
import org.eclipse.jface.viewers.BaseLabelProvider;
import org.eclipse.jface.viewers.IStructuredContentProvider;
import org.eclipse.jface.viewers.ITableLabelProvider;
import org.eclipse.jface.viewers.TableViewer;
import org.eclipse.swt.SWT;
import org.eclipse.swt.events.MouseAdapter;
import org.eclipse.swt.events.MouseEvent;
import org.eclipse.swt.graphics.Image;
import org.eclipse.swt.graphics.Point;
import org.eclipse.swt.layout.FillLayout;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Table;
import org.eclipse.swt.widgets.TableColumn;
import org.eclipse.swt.widgets.TableItem;
import org.eclipse.swt.widgets.Text;
import org.eclipse.ui.IFileEditorInput;
import org.eclipse.ui.forms.IManagedForm;
import org.eclipse.ui.forms.editor.FormEditor;
import org.eclipse.ui.forms.editor.FormPage;
import org.eclipse.ui.forms.widgets.Form;
import org.eclipse.ui.forms.widgets.FormToolkit;
import org.eclipse.ui.forms.widgets.ScrolledForm;

public class GraphicPage extends FormPage {
//	private static final String START_LINE  = "/* MRS graphical configuration*/";
	private FormToolkit toolkit;
	private ScrolledForm scrolledForm;
	private Form form;
	private TableViewer tableViewer;
	private SystemConfigMultiPageEditor editor;
	private ArrayList<Config> list = new ArrayList<Config>();
	private Text textIntro;
	private Table table;
	
	public GraphicPage(FormEditor editor, String id, String title) {
		super(editor, id, title);
		this.editor = (SystemConfigMultiPageEditor) editor;
	}

	@Override
	public void createPartControl(Composite parent) {
		// TODO Auto-generated method stub
		super.createPartControl(parent);
	}
	
	
	@Override
	protected void createFormContent(IManagedForm managedForm) {
		this.toolkit = managedForm.getToolkit();
		this.scrolledForm = managedForm.getForm();
		this.form = this.scrolledForm.getForm();

		createHead();

		createBody();
		managedForm.reflow(true);
		super.createFormContent(managedForm);
	}

	private void createHead() {
		this.toolkit.decorateFormHeading(this.form);
		this.form.setText("Graphic Config for Project");
		String strDesc = "Use graphic controls to config macros in header files.";
		if (strDesc != null) {
			Label labelDesc = this.toolkit.createLabel(this.form.getHead(), strDesc, 64);
			this.form.setHeadClient(labelDesc);
		}
	}

	private void createBody() {
		Composite composite = this.form.getBody();
		composite.setLayout(new GridLayout(2, false));
		
		Composite userComp = this.toolkit.createComposite(composite, SWT.FILL);
		userComp.setLayout(new GridLayout());

		Composite topComp = new Composite(userComp, SWT.NONE);
		GridData gd = new GridData(GridData.FILL_BOTH);
		gd.heightHint = 350;
		topComp.setLayout(new GridLayout());
		topComp.setLayoutData(gd);

		Composite belowComp = new Composite(userComp, SWT.NONE);
		gd = new GridData(GridData.FILL_BOTH);
		gd.heightHint = 100;
		belowComp.setLayout(new GridLayout());
		belowComp.setLayoutData(gd);

		tableViewer = new TableViewer(topComp, SWT.H_SCROLL | SWT.V_SCROLL | SWT.BORDER | SWT.SINGLE);
		table = tableViewer.getTable();

		textIntro = new Text(belowComp, SWT.BORDER | SWT.WRAP | SWT.READ_ONLY | SWT.MULTI | SWT.V_SCROLL);
		gd = new GridData(GridData.FILL_BOTH);
//		gd.heightHint = 100;
		textIntro.setLayoutData(gd);

		tableViewer.getTable().setLinesVisible(true);
		tableViewer.getTable().setHeaderVisible(true);
		addColumns();

		tableViewer.getTable().addMouseListener(new MouseAdapter() {
			@Override
			public void mouseDown(MouseEvent e) {
				Point point = new Point(e.x, e.y);
				TableItem item = table.getItem(point);
				if (item != null) {
					Object obj = item.getData();
					if (obj instanceof Config) {
						Config config = (Config)obj;
						textIntro.setText("Macro:[" + config.getName() + "]");
					}
				}
			}
		});
		tableViewer.setContentProvider(new IStructuredContentProvider() {
			@Override
			public Object[] getElements(Object inputElement) {
				if (inputElement instanceof ArrayList) {
					ArrayList arrayList = (ArrayList) inputElement;
					return arrayList.toArray();

				}
				return new Object[0];
			}
		});
		tableViewer.setLabelProvider(new TableLabelProvider() {
			@Override
			public String getColumnText(Object element, int columnIndex) {
				if (element instanceof Config) {
					Config config = (Config) element;
					if (columnIndex == 0) {
						String str = Config.getConfigNameDisplayMap().get(config.getName());
						if (str != null) {
							return str;
						}
						return config.getName();
					} else if (columnIndex == 1) {
						if (config.isOnlyDefine() && config.getValue() == null) {
							return null;
						} else {
							return config.getValue();
						}
					}
				}
				return "";
			}
		});

		IFileEditorInput fileEditorInput = editor.getFileInput();
		try {
			IStorage storage = fileEditorInput.getStorage();
			InputStream stream = storage.getContents();
			BufferedReader br = new BufferedReader(new InputStreamReader(stream));
			String line = null;
//			boolean bStartRecord = false;
			boolean bStartRecord = true;
			while ((line = br.readLine()) != null) {
//				if (line.contains(START_LINE)) {
//					bStartRecord = true;
//				}

				if (bStartRecord && line.startsWith("#define ")) {
					Config config = null;
					String arr[] = line.split(" ");
					if (arr.length == 2) {
						config = new Config(arr[1], null, null, true);
					} else {
						config = new Config(arr[1], arr[2], null, false);
					}
					list.add(config);
				}
			}

		} catch (Exception e) {
			e.printStackTrace();
		}

		tableViewer.setInput(list);
		table.setLayoutData(new GridData(GridData.FILL_BOTH));

	}

	private void addColumns() {
		Table table = tableViewer.getTable();
		TableColumn column0 = new TableColumn(table, SWT.NONE);
		column0.setText("Property");
		column0.setResizable(false);
		column0.setWidth(250);

		TableColumn column1 = new TableColumn(table, SWT.NONE);
		column1.setText("Value");
		column1.setResizable(false);
		column1.setWidth(310);
	}

	private static abstract class TableLabelProvider extends BaseLabelProvider implements ITableLabelProvider {
		@Override
		public Image getColumnImage(Object element, int columnIndex) {
			return null;
		}
	}

	public void refreshText(String editorText) {
		if (tableViewer != null) {
			list.clear();
//			boolean bStartRecord = false;
			boolean bStartRecord = true;
			String[] lines = editorText.split("\r\n");
			for (int i = 0; i < lines.length; i++) {
				String line = lines[i];
//				if (line.contains(START_LINE)) {
//					bStartRecord = true;
//				}

				if (bStartRecord && line.startsWith("#define ")) {
					Config config = null;
					String arr[] = line.split(" ");
					if (arr.length == 2) {
						config = new Config(arr[1], null, null, true);
					} else {
						config = new Config(arr[1], arr[2], null, false);
					}
					list.add(config);
				}
			}
			tableViewer.refresh();
		}
	}
}
