/*******************************************************************************
 * Copyright (c) 2022, MounRiver Studio
 * All rights reserved. This program and the accompanying materials
 * are made available under the terms of the Eclipse Public License v1.0
 * which accompanies this distribution, and is available at
 * http://www.eclipse.org/legal/epl-v10.html
 *
 * Contributors:
 *    MounRiver Studio  - initial API and implementation
 *******************************************************************************/
package systemConfig;

import org.eclipse.cdt.core.model.ICElement;
import org.eclipse.cdt.core.model.ICProject;
import org.eclipse.core.commands.AbstractHandler;
import org.eclipse.core.commands.ExecutionEvent;
import org.eclipse.core.commands.ExecutionException;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.resources.IResource;
import org.eclipse.jface.dialogs.MessageDialog;
import org.eclipse.jface.viewers.ISelection;
import org.eclipse.jface.viewers.TreeSelection;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.ui.IEditorPart;
import org.eclipse.ui.IWorkbenchPage;
import org.eclipse.ui.IWorkbenchWindow;
import org.eclipse.ui.handlers.HandlerUtil;

import handlers.Messages;

public class MacrosConfigHandler extends AbstractHandler {

	private Shell shell;

	@Override
	public Object execute(ExecutionEvent event) throws ExecutionException {
		IProject project = getFirstProject(event);
		if (project != null) {
			MacrosConfigDialog macrosConfigDialog = new MacrosConfigDialog(shell, project);
			macrosConfigDialog.open();
		} else {
			MessageDialog.openWarning(shell, Messages.ExportTemplateHandler_0, Messages.ExportTemplateHandler_2);
		}

		return null;
	}

	private IProject getFirstProject(ExecutionEvent event) {
		IWorkbenchWindow window = HandlerUtil.getActiveWorkbenchWindow(event);
		IWorkbenchPage activePage = window.getActivePage();
		shell = activePage.getActivePart().getSite().getShell();
		ISelection selection = activePage.getSelection();
		if (selection instanceof TreeSelection) {
			TreeSelection treeSelection = (TreeSelection) selection;
			Object element = treeSelection.getFirstElement();
			if (element instanceof IResource) {
				return ((IResource) element).getProject();
			} else if (element instanceof ICElement) {
				ICProject cProject = ((ICElement) element).getCProject();
				return cProject.getProject();
			} else if (element instanceof IEditorPart) {
				IFile file = (IFile) (((IEditorPart) element).getEditorInput().getAdapter(IFile.class));
				return file.getProject();
			}
		}
		return null;
	}
}
