/*******************************************************************************
 * Copyright (c) 2022, MounRiver Studio
 * All rights reserved. This program and the accompanying materials
 * are made available under the terms of the Eclipse Public License v1.0
 * which accompanies this distribution, and is available at
 * http://www.eclipse.org/legal/epl-v10.html
 *
 * Contributors:
 *    MounRiver Studio  - initial API and implementation
 *******************************************************************************/
package systemConfig;

import java.io.File;

import org.eclipse.core.resources.IFile;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.resources.IResource;
import org.eclipse.core.resources.IResourceChangeEvent;
import org.eclipse.core.resources.IResourceChangeListener;
import org.eclipse.core.resources.IResourceDelta;
import org.eclipse.core.resources.ResourcesPlugin;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.ui.IEditorInput;
import org.eclipse.ui.IEditorPart;
import org.eclipse.ui.IEditorSite;
import org.eclipse.ui.IFileEditorInput;
import org.eclipse.ui.IWorkbenchPage;
import org.eclipse.ui.PartInitException;
import org.eclipse.ui.PlatformUI;
import org.eclipse.ui.editors.text.TextEditor;
import org.eclipse.ui.forms.editor.FormEditor;
@SuppressWarnings("restriction")
public class SystemConfigMultiPageEditor extends FormEditor implements IResourceChangeListener {
	private IFileEditorInput fileInput = null;
	private IProject project;
	private File file;

	private TextEditor textEditor;
	private GraphicPage formPage0;

	public SystemConfigMultiPageEditor() {
		ResourcesPlugin.getWorkspace().addResourceChangeListener(this);
	}

	@Override
	public void init(IEditorSite site, IEditorInput input) throws PartInitException {
		super.init(site, input);

		if ((input != null) && ((input instanceof IFileEditorInput))) {
			this.fileInput = ((IFileEditorInput) input);

			IFile ifile = this.fileInput.getFile();
			this.project = ifile.getProject();

			String fileName = ifile.getName();
			if ((ifile.exists()) && (fileName.equals("config.h"))) {
				try {
					ifile.refreshLocal(IResource.DEPTH_INFINITE, null);
					this.file = new File(ifile.getLocationURI());
				} catch (Exception e) {
					e.printStackTrace();
				}
			}
		}
	}

	@Override
	public void resourceChanged(IResourceChangeEvent event) {
		switch (event.getType()) {
		case 1:
			IResourceDelta rootDelta = event.getDelta();
			if ((rootDelta != null) && (this.fileInput != null)) {
				try {
					IPath inputPath = this.fileInput.getStorage().getFullPath();
					IResourceDelta inputDelta = rootDelta.findMember(inputPath);
					if ((inputDelta != null) && (inputDelta.getKind() == 2)) {
						IResource deltaResource = inputDelta.getResource();
						if ((deltaResource != null) && ((deltaResource instanceof IFile))) {
//							closeSystemConfigurationEditor(new FileEditorInput((IFile) deltaResource));
						}
					}
					if ((inputDelta != null) && (inputDelta.getKind() == 4)) {
						IResource deltaResource = inputDelta.getResource();
						if ((deltaResource != null) && ((deltaResource instanceof IFile))) {
//							updateSystemConfigurationEditor();
							fileInput = null;
						}
					}
				} catch (CoreException e) {
					e.printStackTrace();
				}
			}
			break;
		}
	}

	@Override
	protected void addPages() {
		try {
			IWorkbenchPage page = PlatformUI.getWorkbench().getActiveWorkbenchWindow().getActivePage();
			
			formPage0 = new GraphicPage(this, "page0", "Page0");
			int index = addPage(formPage0);
			setPageText(index, "Graphic");
			setPageImage(index, null);
			
			textEditor = new TextEditor();
			int index2 = addPage(textEditor, fileInput);
			setPageText(index2, "Text");
			setPageImage(index2, null);
			
		} catch (PartInitException e) {
		}
	}

	@Override
	public void doSave(IProgressMonitor monitor) {
	    this.textEditor.doSave(monitor);
	    if (this.textEditor != null)
	    {
	      this.textEditor.doSave(monitor);
	      firePropertyChange(257);
	    }
	}

	@Override
	public void doSaveAs() {
	    IEditorPart editor = getEditor(0);
	    editor.doSaveAs();
	    setPageText(0, editor.getTitle());
	    setInput(editor.getEditorInput());
	}
	
	@Override
	protected void pageChange(int newPageIndex) {
		if (newPageIndex == 0) {
			String editorText = this.textEditor.getDocumentProvider().getDocument(this.textEditor.getEditorInput())
					.get();
			formPage0.refreshText(editorText);
//	      formPage0.refresh();
//	      this.manager.getSourceList().clear();
//	      this.manager.parseLine(this.sourceFile, editorText);
//	      if (this.wizardEditor.getViewer() != null) {
//	        this.wizardEditor.getViewer().refresh();
//	      }
		}
		super.pageChange(newPageIndex);
	}

	@Override
	public boolean isSaveAsAllowed() {
		return true;
	}

	@Override
	public void dispose() {
		ResourcesPlugin.getWorkspace().removeResourceChangeListener(this);
		super.dispose();
	}

	public IFileEditorInput getFileInput() {
		return fileInput;
	}
	
	@Override
	public boolean isDirty() {
	    if (this.textEditor.isDirty()) {
	        return true;
	      }
	      return (this.formPage0 != null) && (this.formPage0.isDirty());
	}
}
