/*******************************************************************************
 * Copyright (c) 2022, MounRiver Studio
 * All rights reserved. This program and the accompanying materials
 * are made available under the terms of the Eclipse Public License v1.0
 * which accompanies this distribution, and is available at
 * http://www.eclipse.org/legal/epl-v10.html
 *
 * Contributors:
 *    MounRiver Studio  - initial API and implementation
 *******************************************************************************/
package template;

import java.io.File;

import org.eclipse.jface.dialogs.Dialog;
import org.eclipse.jface.dialogs.IDialogConstants;
import org.eclipse.jface.dialogs.MessageDialog;
import org.eclipse.jface.dialogs.TitleAreaDialog;
import org.eclipse.osgi.util.NLS;
import org.eclipse.swt.SWT;
import org.eclipse.swt.events.ModifyEvent;
import org.eclipse.swt.events.ModifyListener;
import org.eclipse.swt.events.SelectionAdapter;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Combo;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.DirectoryDialog;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.swt.widgets.Text;

import extern.Messages;
import wizard.NewWizardPage;

public class ProjectExportAsTemplateDialog extends TitleAreaDialog {
	private String title;
	private String headerTitle;
	private String message;
	private Text textVendor;
	private Text textSeries;
	private Text textTargetPath;

	private String vendor;
	private String toolchain;
	private String series;
	private String rtos;
	private String description;
	private String path;
	private Text textDesc;
	private Combo comboTc;
	private Combo comboRTOS;

	public ProjectExportAsTemplateDialog(Shell parentShell, String vendor, String toolchain, String series, String rtos, String description,
			String projName) {
		super(parentShell);
		this.vendor = vendor;
		this.toolchain = toolchain;
		this.series = series;
		this.rtos = rtos;
		this.description = description;
		this.title = Messages.ExportTemplateDialog_DialogTitle;
		this.headerTitle = NLS.bind(Messages.ExportTemplateDialog_Title, projName);
		this.message = Messages.ExportTemplateDialog_Info;
		setShellStyle(getShellStyle() | SWT.SHEET);
	}

	protected void configureShell(Shell shell) {
		super.configureShell(shell);
		shell.setText(this.title);
//		shell.setSize(600, 360);
	}

	@Override
	protected Control createDialogArea(Composite parent) {
		setTitle(this.headerTitle);
		setMessage(this.message);
		
		// top level composite
		Composite parentComposite = (Composite) super.createDialogArea(parent);
		
		Composite userComp = new Composite(parentComposite, SWT.NONE);
		GridLayout layout = new GridLayout(6, false);
		layout.marginHeight = convertVerticalDLUsToPixels(IDialogConstants.VERTICAL_MARGIN);
		layout.marginWidth = convertHorizontalDLUsToPixels(IDialogConstants.HORIZONTAL_MARGIN);
		layout.verticalSpacing = convertVerticalDLUsToPixels(IDialogConstants.VERTICAL_SPACING);
		layout.horizontalSpacing = convertHorizontalDLUsToPixels(IDialogConstants.HORIZONTAL_SPACING);
		userComp.setLayout(layout);

		GridData gd = new GridData(GridData.FILL_BOTH);
		gd.verticalIndent = 5;
		userComp.setLayoutData(gd);
		userComp.setFont(parentComposite.getFont());

		// Vendor
		Label labelVendor = new Label(userComp, SWT.NONE);
		gd = new GridData(GridData.HORIZONTAL_ALIGN_BEGINNING);
		labelVendor.setLayoutData(gd);
		labelVendor.setText(Messages.ExportTemplateDialog_Vendor);

		textVendor = new Text(userComp, SWT.BORDER);
		gd = new GridData(GridData.HORIZONTAL_ALIGN_BEGINNING);
		gd.widthHint = 120;
		textVendor.setLayoutData(gd);
		textVendor.setText(vendor);
		textVendor.setSelection(vendor.length());
		textVendor.setToolTipText(vendor);
		textVendor.addModifyListener(new ModifyListener() {

			@Override
			public void modifyText(ModifyEvent e) {
				handleStoreAllWidgetValue();
			}
		});

		// Toolchain
		Label labelTc = new Label(userComp, SWT.NONE);
		gd = new GridData(GridData.HORIZONTAL_ALIGN_BEGINNING);
		labelTc.setLayoutData(gd);
		labelTc.setText(Messages.TemplateExportDialog_4);

		comboTc = new Combo(userComp, SWT.READ_ONLY);
		gd = new GridData(GridData.HORIZONTAL_ALIGN_BEGINNING);
		gd.widthHint = 105;
		comboTc.setLayoutData(gd);
		comboTc.setItems(new String[] { "RISC-V", "ARM" }); //$NON-NLS-1$ //$NON-NLS-2$
		if (toolchain.equals("RISC-V")) { //$NON-NLS-1$
			comboTc.select(0);
		} else if (toolchain.equals("ARM")) { //$NON-NLS-1$
			comboTc.select(1);
		}
		comboTc.addModifyListener(new ModifyListener() {

			@Override
			public void modifyText(ModifyEvent e) {
				handleStoreAllWidgetValue();
			}
		});
		
		// Series
		Label labelSeries = new Label(userComp, SWT.NONE);
		gd = new GridData(GridData.HORIZONTAL_ALIGN_END);
		labelSeries.setLayoutData(gd);
		labelSeries.setText(Messages.ExportTemplateDialog_Series);

		textSeries = new Text(userComp, SWT.BORDER);
		gd = new GridData(GridData.HORIZONTAL_ALIGN_BEGINNING);
		gd.widthHint = 120;
		textSeries.setLayoutData(gd);
		textSeries.setText(series);
		textSeries.setToolTipText(series);

		textSeries.addModifyListener(new ModifyListener() {

			@Override
			public void modifyText(ModifyEvent e) {
				handleStoreAllWidgetValue();
			}
		});

		// RTOS Type
		Label labelRTOS = new Label(userComp, SWT.NONE);
		gd = new GridData(GridData.HORIZONTAL_ALIGN_BEGINNING);
		labelRTOS.setLayoutData(gd);
		labelRTOS.setText(Messages.ExportTemplateDialog_RTOSType);

		comboRTOS = new Combo(userComp, SWT.READ_ONLY);
		gd = new GridData(GridData.HORIZONTAL_ALIGN_BEGINNING);
		gd.widthHint = 105;
		comboRTOS.setLayoutData(gd);
		comboRTOS.setItems(NewWizardPage.RTOSARR); //$NON-NLS-1$ //$NON-NLS-2$
		for (int index = 0; index < NewWizardPage.RTOSARR.length; index++) {
			if (rtos.equals(NewWizardPage.RTOSARR[index])) {
				comboRTOS.select(index);
			}
		}
		comboRTOS.addModifyListener(new ModifyListener() {

			@Override
			public void modifyText(ModifyEvent e) {
				handleStoreAllWidgetValue();
			}
		});
//		// Type
//		Label labelType = new Label(userComp, SWT.NONE);
//		gd = new GridData(GridData.HORIZONTAL_ALIGN_CENTER);
//		labelType.setLayoutData(gd);
//		labelType.setText(Messages.ExportTemplateDialog_TemplateName);
//
//		textTemplateName = new Text(userComp, SWT.BORDER);
//		gd = new GridData(GridData.HORIZONTAL_ALIGN_BEGINNING);
//		gd.widthHint = 120;
//		textTemplateName.setLayoutData(gd);
//		textTemplateName.setText(name);
//		textTemplateName.setToolTipText(name);
//		textTemplateName.setFocus();
//		textTemplateName.selectAll();
//		textTemplateName.addModifyListener(new ModifyListener() {
//
//			@Override
//			public void modifyText(ModifyEvent e) {
//				handleStoreAllWidgetValue();
//			}
//		});


//		Label empty = new Label(userComp, SWT.NONE);
//		gd = new GridData(GridData.FILL_HORIZONTAL);
//		gd.horizontalSpan = 2;
//		empty.setLayoutData(gd);
//		empty.setText("");
		
		// Export Path
		Label libFolder = new Label(userComp, SWT.NONE);
		gd = new GridData(GridData.HORIZONTAL_ALIGN_BEGINNING);
		libFolder.setLayoutData(gd);
		libFolder.setText(Messages.ExportTemplateDialog_ExportPath);

		textTargetPath = new Text(userComp, SWT.BORDER | SWT.READ_ONLY);
		textTargetPath.setEnabled(false);
		gd = new GridData(GridData.FILL_HORIZONTAL);
		gd.horizontalSpan = 2;
		textTargetPath.setLayoutData(gd);
//		String strUri = Platform.getInstallLocation().getURL().getFile() + "template" + File.separator + "wizard"
//				+ File.separator + vendor + File.separator + toolchain + File.separator + series;
//		String strFile = new File(strUri).getAbsolutePath();
//		textTargetPath.setText(strFile);
//		textTargetPath.setToolTipText(strFile);
	
		Button btnBrowse = new Button(userComp, SWT.NONE);
		gd = new GridData();
		btnBrowse.setLayoutData(gd);
		btnBrowse.setText(Messages.ExportTemplateDialog_Browse);
		btnBrowse.addSelectionListener(new SelectionAdapter() {
			@Override
			public void widgetSelected(SelectionEvent e) {
				DirectoryDialog directoryDialog = new DirectoryDialog(getShell());
				String path = directoryDialog.open();
				if (path != null) {
					File file = new File(path);
					if (file != null && file.exists() && file.isDirectory()) {
						textTargetPath.setText(path);
						textTargetPath.setToolTipText(path);
						handleStoreAllWidgetValue();
					}
				}
			}
		});
		textDesc = new Text(userComp, SWT.BORDER | SWT.MULTI | SWT.WRAP | SWT.V_SCROLL);
		gd = new GridData(GridData.FILL_BOTH);
		gd.widthHint = 600;
		gd.horizontalSpan = 6;
		textDesc.setLayoutData(gd);
		textDesc.setText(description);
		
		setHelpAvailable(false);
		Dialog.applyDialogFont(parentComposite);
		return parentComposite;
	}

	@Override
	protected void initializeBounds() {
		handleStoreAllWidgetValue();
		super.initializeBounds();
	}

	private void handleStoreAllWidgetValue() {
		String tempVendor = textVendor.getText().trim();
		String tempToolchain = comboTc.getText().trim();
		String tempSeries = textSeries.getText().trim();
		String tempRTOS = comboRTOS.getText().trim();

		Button buttonGetOK = getButton(0);
		if (buttonGetOK != null) {
			buttonGetOK.setEnabled(tempVendor.trim().length() > 0 && tempToolchain.trim().length() > 0
					&& tempSeries.trim().length() > 0 && tempRTOS.trim().length() > 0
					&& textTargetPath.getText().trim().length() > 0);
		}
	}

	@Override
	protected void okPressed() {
		vendor = textVendor.getText().trim();
		toolchain = comboTc.getText().trim();
		series = textSeries.getText().trim();
		rtos = comboRTOS.getText().trim();
		description = textDesc.getText().trim();
		path = textTargetPath.getText().trim();
		if (vendor == null || vendor.isEmpty()) {
			showMessageDialog(Messages.TemplateExportDialog_0);
			return;
		}
		if (toolchain == null || toolchain.isEmpty()) {
			showMessageDialog(Messages.TemplateExportDialog_9);
			return;
		}
		
		if (rtos == null || rtos.isEmpty()) {
			showMessageDialog("RTOS Type cannot be empty.");
			return;
		}
		
		if (series == null || series.isEmpty()) {
			showMessageDialog(Messages.TemplateExportDialog_1);
			return;
		}
		if (path == null || path.isEmpty()) {
			showMessageDialog(Messages.TemplateExportDialog_3);
			return;
		}
		super.okPressed();
	}

	@Override
	protected void cancelPressed() {
		super.cancelPressed();
	}

	private void showMessageDialog(String message) {
		MessageDialog.openWarning(getShell(), Messages.AddExternLinkFolderDialog_12, message);
	}

	public String getVendor() {
		return vendor;
	}

	public String getToolchain() {
		return toolchain;
	}

	public String getSeries() {
		return series;
	}
	
	public String getRTOS() {
		return rtos;
	}

	public String getPath() {
		return path;
	}

	public String getDescription() {
		return description;
	}
}
