/*******************************************************************************
 * Copyright (c) 2022, MounRiver Studio
 * All rights reserved. This program and the accompanying materials
 * are made available under the terms of the Eclipse Public License v1.0
 * which accompanies this distribution, and is available at
 * http://www.eclipse.org/legal/epl-v10.html
 *
 * Contributors:
 *    MounRiver Studio  - initial API and implementation
 *******************************************************************************/
package template;

import java.io.File;
import java.util.ArrayList;

import org.eclipse.core.runtime.Platform;
import org.eclipse.jface.viewers.ITreeContentProvider;

public class TemplateContentProvider implements ITreeContentProvider {
	private String filter = "";

	@Override
	public Object[] getElements(Object inputElement) {
		if (inputElement instanceof ArrayList) {
			ArrayList<File> vendorlist = new ArrayList<File>();
			ArrayList<?> list = (ArrayList<?>) inputElement;
			for (Object obj : list) {
				if (obj instanceof File) {
					File file = (File) obj;
					boolean isFound = false;
					if (!file.isDirectory())
						continue;
					for (File fileTc : file.listFiles()) {
						if (isFound)
							break;
						if (!fileTc.isDirectory())
							continue;
						for (File fileSeries : fileTc.listFiles()) {
							if (isFound)
								break;
							if (!fileSeries.isDirectory())
								continue;
							for (File fileTS : fileSeries.listFiles()) {
								if (isFound)
									break;
								if (!fileTS.isDirectory())
									continue;
								for (File fileType : fileTS.listFiles()) {
									if (fileType.getName().endsWith(".zip") && (filter.isEmpty()
											|| fileType.getName().toUpperCase().contains(filter.toUpperCase()))) {
										isFound = true;
										break;
									}
								}
							}
						}
					}
					if (!isFound) {
						continue;
					}

					if (file.getName().equalsIgnoreCase("WCH")) {
						vendorlist.add(0, file);
					} else {
						vendorlist.add(file);
					}
				}
			}
			return vendorlist.toArray();
		}
		return null;
	}

	@Override
	public Object[] getChildren(Object parentElement) {
		if (parentElement instanceof File) {
			File fParent = (File) parentElement;
			if (fParent.isDirectory()) {
				ArrayList<File> seriesList = new ArrayList<File>();
				ArrayList<File> tsList = new ArrayList<File>();
				ArrayList<File> typeList = new ArrayList<File>();

				for (File child : fParent.listFiles()) {
					String strWizardPath = new File(
							Platform.getInstallLocation().getURL().getFile() + "template" + File.separator + "wizard")
									.getAbsolutePath();
					if (child.isDirectory()) {
						String relativePath = child.getAbsolutePath().replace(strWizardPath, "");
						if (relativePath.split("\\\\").length > 5) {
							continue;
						}
//						// ignore if no type zip existed, typically the situation only remain a series
//						// folder after delete.
//						boolean hasZip = false;
//						for (File f : child.listFiles()) {
//							if (f.getName().endsWith(".zip")) {
//								hasZip = true;
//								break;
//							}
//						}
//						if (!hasZip) {
//							continue;
//						}

						if (child.getName().equals("RISC-V") || child.getName().equals("ARM")) {
							File[] grandChildren = child.listFiles();
							for (File grandChild : grandChildren) {
								boolean isFound = false;
								if (!grandChild.isDirectory())
									continue;
								for (File fitleTS : grandChild.listFiles()) {
									if (!fitleTS.isDirectory())
										continue;
									for (File fileType : fitleTS.listFiles()) {
										if (fileType.getName().endsWith(".zip") && (filter.isEmpty()
												|| fileType.getName().toUpperCase().contains(filter.toUpperCase()))) {
											isFound = true;
											break;
										}
									}
								}
								if (!isFound) {
									continue;
								}
								seriesList.add(grandChild);
							}
						}

						if (child.getName().equals("MCU") || child.getName().equals("RTOS")) {
							// skip this level
							boolean isFound = false;
							for (File fileType : child.listFiles()) {
								if (fileType.getName().endsWith(".zip") && (filter.isEmpty()
										|| fileType.getName().toUpperCase().contains(filter.toUpperCase()))) {
									isFound = true;
									tsList.add(child);
									break;
								}
								if (!isFound) {
									continue;
								}
							}
						}
					}

					if (seriesList.isEmpty() && tsList.isEmpty()) {
						if (child.getName().endsWith(".descry") || child.getName().endsWith(".svd")) {
							continue;
						}

						if (filter.isEmpty() || child.getName().toUpperCase().contains(filter.toUpperCase())) {
							typeList.add(child);
						}
					}
				}
				if (!seriesList.isEmpty()) {
					return seriesList.toArray();
				}

				if (!tsList.isEmpty()) {
					return tsList.toArray();
				}

				return typeList.toArray();
			}
		}
		return null;
	}

	@Override
	public Object getParent(Object element) {
		return null;
	}

	@Override
	public boolean hasChildren(Object element) {
		if (element instanceof File) {
			File file = (File) element;
			return file.isDirectory();
		}
		return false;
	}

	public void setFilter(String filter) {
		this.filter = filter;
	}
}
