/*******************************************************************************
 * Copyright (c) 2022, MounRiver Studio
 * All rights reserved. This program and the accompanying materials
 * are made available under the terms of the Eclipse Public License v1.0
 * which accompanies this distribution, and is available at
 * http://www.eclipse.org/legal/epl-v10.html
 *
 * Contributors:
 *    MounRiver Studio  - initial API and implementation
 *******************************************************************************/
package template;

import java.io.File;

import org.eclipse.core.runtime.Platform;
import org.eclipse.jface.dialogs.Dialog;
import org.eclipse.jface.dialogs.IDialogConstants;
import org.eclipse.jface.dialogs.MessageDialog;
import org.eclipse.jface.dialogs.TitleAreaDialog;
import org.eclipse.swt.SWT;
import org.eclipse.swt.events.ModifyEvent;
import org.eclipse.swt.events.ModifyListener;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Combo;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.swt.widgets.Text;

import wizard.NewWizardPage;

public class TemplateCopyDialog extends TitleAreaDialog {

	private Text textVendor;
	private Text textSeries;
	private Text textType;
	private String title = ""; //$NON-NLS-1$
	private String message = ""; //$NON-NLS-1$
	private String vendor = ""; //$NON-NLS-1$
	private String toolchain = ""; //$NON-NLS-1$
	private String series = ""; //$NON-NLS-1$
	private String rttype = ""; //$NON-NLS-1$
	private String type = ""; //$NON-NLS-1$
	private String originType = ""; //$NON-NLS-1$
	private Combo comboToolChain;
	private Combo comboRTType;

	protected TemplateCopyDialog(Shell parentShell, String title, String message, String vendor, String toolchain,
			String series, String rttype, String type, String originType) {
		super(parentShell);
		setShellStyle(getShellStyle() | SWT.SHEET);
		this.title = title;
		this.message = message;
		this.vendor = vendor;
		this.toolchain = toolchain;
		this.series = series;
		this.rttype = rttype;
		this.type = type;
		this.originType = originType;
	}

	@Override
	protected void configureShell(Shell newShell) {
		super.configureShell(newShell);
		newShell.setText(title);
//		newShell.setSize(330, 300);
	}

	@Override
	protected Control createDialogArea(Composite parent) {
		setTitle(title);
		setMessage(message);
		
		// top level composite
		Composite parentComposite = (Composite) super.createDialogArea(parent);
		
		Composite userComp = new Composite(parentComposite, SWT.FILL);
		GridLayout layout = new GridLayout(2, false);
		layout.marginHeight = convertVerticalDLUsToPixels(IDialogConstants.VERTICAL_MARGIN);
		layout.marginWidth = convertHorizontalDLUsToPixels(IDialogConstants.HORIZONTAL_MARGIN);
		layout.verticalSpacing = convertVerticalDLUsToPixels(IDialogConstants.VERTICAL_SPACING);
		layout.horizontalSpacing = convertHorizontalDLUsToPixels(IDialogConstants.HORIZONTAL_SPACING);
		userComp.setLayout(layout);
		
		GridData gd = new GridData(GridData.FILL_BOTH);
		userComp.setLayoutData(gd);
		userComp.setFont(parentComposite.getFont());

		createVendorText(userComp);

		createToolChainCombo(userComp);

		createSeriesText(userComp);

		createRTTypeText(userComp);

		createTypeText(userComp);

		addActions();

		handleStoreAllWidgetValue();

		textType.selectAll();
		textType.setFocus();
		
		setHelpAvailable(false);
		Dialog.applyDialogFont(parentComposite);
		return parentComposite;
	}

	private void addActions() {
		textVendor.addModifyListener(new ModifyListener() {

			@Override
			public void modifyText(ModifyEvent e) {
				handleStoreAllWidgetValue();
			}
		});

		comboToolChain.addModifyListener(new ModifyListener() {

			@Override
			public void modifyText(ModifyEvent e) {
				handleStoreAllWidgetValue();
			}
		});

		textSeries.addModifyListener(new ModifyListener() {

			@Override
			public void modifyText(ModifyEvent e) {
				handleStoreAllWidgetValue();
			}
		});

		comboRTType.addModifyListener(new ModifyListener() {

			@Override
			public void modifyText(ModifyEvent e) {
				handleStoreAllWidgetValue();
			}
		});

		textType.addModifyListener(new ModifyListener() {

			@Override
			public void modifyText(ModifyEvent e) {
				handleStoreAllWidgetValue();
			}
		});
	}

	private void createVendorText(Composite parent) {
		Label labelVendor = new Label(parent, SWT.NONE);
		labelVendor.setText(Messages.TemplateCopyDialog_4);
		GridData gd = new GridData();
		gd.horizontalIndent = 5;
		labelVendor.setLayoutData(gd);

		textVendor = new Text(parent, 2052);
		textVendor.setTextLimit(50);
		gd = new GridData(GridData.FILL_HORIZONTAL);
		gd.widthHint = 200;
		textVendor.setLayoutData(gd);
		textVendor.setText(vendor);
	}

	private void createToolChainCombo(Composite parent) {
		Label labelToolChain = new Label(parent, SWT.NONE);
		labelToolChain.setText(Messages.TemplateCopyDialog_61);
		GridData gd = new GridData();
		gd.horizontalIndent = 5;
		labelToolChain.setLayoutData(gd);

		comboToolChain = new Combo(parent, SWT.DROP_DOWN | SWT.READ_ONLY);
		comboToolChain.setItems(new String[] { "RISC-V", "ARM" });
		gd = new GridData(GridData.FILL_HORIZONTAL);
		gd.widthHint = 200;
		comboToolChain.setLayoutData(gd);
		if (toolchain.equals("RISC-V")) {
			comboToolChain.select(0);
		} else if (toolchain.equals("ARM")) {
			comboToolChain.select(1);
		}
	}

	private void createSeriesText(Composite parent) {
		Label labelSeries = new Label(parent, SWT.NONE);
		labelSeries.setText(Messages.TemplateCopyDialog_5);
		GridData gd = new GridData();
		gd.horizontalIndent = 5;
		labelSeries.setLayoutData(gd);

		textSeries = new Text(parent, 2052);
		textSeries.setTextLimit(50);
		gd = new GridData(GridData.FILL_HORIZONTAL);
		gd.widthHint = 200;
		textSeries.setLayoutData(gd);
		textSeries.setText(series);
	}

	private void createRTTypeText(Composite parent) {
		Label labelRTType = new Label(parent, SWT.NONE);
		labelRTType.setText(Messages.TemplateCopyDialog_62);
		GridData gd = new GridData();
		gd.horizontalIndent = 5;
		labelRTType.setLayoutData(gd);

		comboRTType = new Combo(parent, SWT.DROP_DOWN | SWT.READ_ONLY);
		comboRTType.setItems(NewWizardPage.RTOSARR);
		gd = new GridData(GridData.FILL_HORIZONTAL);
		gd.widthHint = 200;
		comboRTType.setLayoutData(gd);
		for (int index = 0; index < NewWizardPage.RTOSARR.length; index++) {
			if (rttype.equals(NewWizardPage.RTOSARR[index])) {
				comboRTType.select(index);
			}
		}
	}

	private void createTypeText(Composite parent) {
		Label labelType = new Label(parent, SWT.NONE);
		labelType.setText(Messages.TemplateCopyDialog_6);
		GridData gd = new GridData();
		gd.horizontalIndent = 5;
		labelType.setLayoutData(gd);

		textType = new Text(parent, 2052);
		textType.setTextLimit(50);
		gd = new GridData(GridData.FILL_HORIZONTAL);
		gd.widthHint = 200;
		textType.setLayoutData(gd);
		textType.setText(type);
	}

	private void handleStoreAllWidgetValue() {
		vendor = textVendor.getText().trim();
		toolchain = comboToolChain.getText().trim();
		series = textSeries.getText().trim();
		rttype = comboRTType.getText().trim();
		type = textType.getText().trim();

		Button buttonGetOK = getButton(0);
		if (buttonGetOK != null) {
			buttonGetOK.setEnabled(!originType.trim().equals(type.trim()) && vendor.trim().length() > 0
					&& toolchain.trim().length() > 0 && series.trim().length() > 0 && rttype.trim().length() > 0
					&& type.trim().length() > 0);
		}
	}


	@Override
	protected void okPressed() {
		String seriesPath = Platform.getInstallLocation().getURL().getFile() + "template" //$NON-NLS-1$
				+ File.separator + "wizard" + File.separator + vendor + File.separator + toolchain + File.separator //$NON-NLS-1$
				+ series + File.separator + rttype;
		String typePath = seriesPath + File.separator + type + ".zip"; //$NON-NLS-1$
		File fileType = new File(typePath);
		if (fileType.exists()) {
			boolean result = MessageDialog.openQuestion(getShell(), Messages.TemplateManageDialog_39,
					Messages.TemplateManageDialog_40);
			if (!result) {
				return;
			}
			fileType.delete();
		}
		super.okPressed();
	}
	
	public String getVendor() {
		return vendor;
	}

	public String getToolchain() {
		return toolchain;
	}

	public String getSeries() {
		return series;
	}

	public String getRttype() {
		return rttype;
	}
	
	public String getType() {
		return type;
	}
}
