/*******************************************************************************
 * Copyright (c) 2022, MounRiver Studio
 * All rights reserved. This program and the accompanying materials
 * are made available under the terms of the Eclipse Public License v1.0
 * which accompanies this distribution, and is available at
 * http://www.eclipse.org/legal/epl-v10.html
 *
 * Contributors:
 *    MounRiver Studio  - initial API and implementation
 *******************************************************************************/
package template;

import org.eclipse.jface.dialogs.Dialog;
import org.eclipse.jface.dialogs.IDialogConstants;
import org.eclipse.jface.dialogs.MessageDialog;
import org.eclipse.jface.dialogs.TitleAreaDialog;
import org.eclipse.swt.SWT;
import org.eclipse.swt.events.SelectionAdapter;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.DirectoryDialog;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.swt.widgets.Text;

public class TemplateExportDialog extends TitleAreaDialog {
	private static final String EMPTY_STR = ""; // $NON-NLS-1$
	private String title;
	private final String headerTitle;
	private final String message;
	private Text text;
	private String exportPath = EMPTY_STR;

	public TemplateExportDialog(Shell parentShell) {
		this(parentShell, Messages.TemplateExportDialog_3, Messages.TemplateExportDialog_3,
				Messages.TemplateExportDialog_2); // $NON-NLS-1$ //$NON-NLS-1$
		setShellStyle(getShellStyle() | SWT.SHEET);
	}

	public TemplateExportDialog(Shell parentShell, String title, String headerTitle, String message) {
		super(parentShell);
		this.title = title;
		this.headerTitle = headerTitle;
		this.message = message;
		setShellStyle(getShellStyle() | SWT.SHEET);
	}

	protected void configureShell(Shell shell) {
		super.configureShell(shell);
		shell.setText(this.title);
//		shell.setSize(533, 230);
	}

	@Override
	protected Control createDialogArea(Composite parent) {
		setTitle(this.headerTitle);
		setMessage(this.message);

		// top level composite
		Composite parentComposite = (Composite) super.createDialogArea(parent);
		
		Composite userComp = new Composite(parentComposite, SWT.FILL);
		GridLayout layout = new GridLayout(3, false);
		layout.marginHeight = convertVerticalDLUsToPixels(IDialogConstants.VERTICAL_MARGIN);
		layout.marginWidth = convertHorizontalDLUsToPixels(IDialogConstants.HORIZONTAL_MARGIN);
		layout.verticalSpacing = convertVerticalDLUsToPixels(IDialogConstants.VERTICAL_SPACING);
		layout.horizontalSpacing = convertHorizontalDLUsToPixels(IDialogConstants.HORIZONTAL_SPACING);
		userComp.setLayout(layout);
		
		GridData gd = new GridData(GridData.FILL_BOTH);
		gd.verticalIndent = 5;
		userComp.setLayoutData(gd);
		userComp.setFont(parentComposite.getFont());

		Label label = new Label(userComp, SWT.NONE);
		gd = new GridData(GridData.BEGINNING);
		label.setLayoutData(gd);
		label.setText(Messages.TemplateExportDialog_1);

		text = new Text(userComp, SWT.BORDER | SWT.READ_ONLY);
		gd = new GridData(GridData.FILL_HORIZONTAL);
		gd.horizontalIndent = 10;
		text.setLayoutData(gd);

		Button btn = new Button(userComp, SWT.PUSH);
		btn.setText(Messages.TemplateExportDialog_0);
		gd = new GridData(GridData.BEGINNING);
		btn.setLayoutData(gd);

		btn.addSelectionListener(new SelectionAdapter() {
			@Override
			public void widgetSelected(SelectionEvent e) {
				DirectoryDialog directoryDialog = new DirectoryDialog(getShell(), SWT.SHEET);
				directoryDialog.setText(EMPTY_STR); // $NON-NLS-1$
				directoryDialog.setMessage(EMPTY_STR); // $NON-NLS-1$
				String str = directoryDialog.open();
				if (str != null) {
					text.setText(str);
					text.setToolTipText(str);
				}
			}
		});
		
		setHelpAvailable(false);
		Dialog.applyDialogFont(parentComposite);
		
		return parentComposite;
	}

	@Override
	protected void okPressed() {
		if (text.getText().isEmpty()) {
			MessageDialog.openInformation(getShell(), Messages.TemplateExportDialog_5, Messages.TemplateExportDialog_6);
			return;
		} else {
			exportPath = text.getText();
		}
		super.okPressed();
	}

	public String getExportPath() {
		return exportPath;
	}
}
