/*******************************************************************************
 * Copyright (c) 2022, MounRiver Studio
 * All rights reserved. This program and the accompanying materials
 * are made available under the terms of the Eclipse Public License v1.0
 * which accompanies this distribution, and is available at
 * http://www.eclipse.org/legal/epl-v10.html
 *
 * Contributors:
 *    MounRiver Studio  - initial API and implementation
 *******************************************************************************/
package template;

import java.io.File;

import org.eclipse.core.runtime.Platform;
import org.eclipse.jface.viewers.ILabelProviderListener;
import org.eclipse.jface.viewers.ITableLabelProvider;
import org.eclipse.swt.graphics.Image;
import org.eclipse.wb.swt.ResourceManager;

public class TemplateLabelProvider implements ITableLabelProvider {
	private static Image imgVendor = ResourceManager.getPluginImage("com.mounriver.project", "icon/vendor.png");
	private static Image imgSeries = ResourceManager.getPluginImage("com.mounriver.project", "icon/series.png");
	private static Image imgRTType = ResourceManager.getPluginImage("com.mounriver.project", "icon/rttype.png");
	private static Image imgType = ResourceManager.getPluginImage("com.mounriver.project", "icon/type.png");

	@Override
	public void addListener(ILabelProviderListener listener) {
		// TODO Auto-generated method stub

	}

	@Override
	public void dispose() {
		// TODO Auto-generated method stub

	}

	@Override
	public boolean isLabelProperty(Object element, String property) {
		// TODO Auto-generated method stub
		return false;
	}

	@Override
	public void removeListener(ILabelProviderListener listener) {
		// TODO Auto-generated method stub

	}

	@Override
	public Image getColumnImage(Object element, int columnIndex) {
		if (element instanceof File) {
			if (columnIndex == 0) {
				File file = (File) element;
				String fullpath = file.getAbsolutePath();
				String rootpath = Platform.getInstallLocation().getURL().getFile() + "template" + File.separator
						+ "wizard";
				String relativepath = fullpath.replace(new File(rootpath).getAbsolutePath(), "");
				String[] splitArr = relativepath.split("\\\\");
				if (splitArr.length == 2) {
					return imgVendor;
				} else if (splitArr.length == 4) {
					return imgSeries;
				} else if (splitArr.length == 5) {
					return imgRTType;
				} else if (splitArr.length == 6) {
					return imgType;
				}
			}
		}
		return null;
	}

	@Override
	public String getColumnText(Object element, int columnIndex) {
		if (element instanceof File) {
			File file = (File) element;
			if (columnIndex == 0) {
				if (file.getName().endsWith(".zip")) {
					return file.getName().replace(".zip", "");
				}
				if (file.getParentFile().getName().equals("RISC-V")
						|| file.getParentFile().getName().equals("ARM")) {
					return file.getName() + " [" + file.getParentFile().getName() + "]";
				}
				return file.getName();
			}
		}
		return null;
	}
}
