/*******************************************************************************
 * Copyright (c) 2022, MounRiver Studio
 * All rights reserved. This program and the accompanying materials
 * are made available under the terms of the Eclipse Public License v1.0
 * which accompanies this distribution, and is available at
 * http://www.eclipse.org/legal/epl-v10.html
 *
 * Contributors:
 *    MounRiver Studio  - initial API and implementation
 *******************************************************************************/
package wizard;

import org.eclipse.jface.dialogs.Dialog;
import org.eclipse.jface.dialogs.IDialogConstants;
import org.eclipse.jface.dialogs.MessageDialog;
import org.eclipse.jface.dialogs.TitleAreaDialog;
import org.eclipse.swt.SWT;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.swt.widgets.Text;

import importDialog.Messages;

public class CreateFolderDialog extends TitleAreaDialog {
	private String title;
	private final String headerTitle;
	private final String message;
	private Text text;
	private String folderName = ""; //$NON-NLS-1$

	public CreateFolderDialog(Shell parentShell) {
		this(parentShell, Messages.CreateFolderDialog_1, Messages.CreateFolderDialog_2, null); // $NON-NLS-1$
		setShellStyle(getShellStyle() | SWT.SHEET);
	}

	public CreateFolderDialog(Shell parentShell, String title, String headerTitle, String message) {
		super(parentShell);
		this.title = title;
		this.headerTitle = headerTitle;
		this.message = message;
		setShellStyle(getShellStyle());
	}

	protected void configureShell(Shell shell) {
		super.configureShell(shell);
		shell.setText(this.title);
//		shell.setSize(533, 230);
	}

	@Override
	protected Control createDialogArea(Composite parent) {
		setTitle(this.headerTitle);
		setMessage(this.message);

		// top level composite
		Composite parentComposite = (Composite) super.createDialogArea(parent);

		Composite userComp = new Composite(parentComposite, SWT.FILL);
		GridLayout layout = new GridLayout(2, false);
		layout.marginHeight = convertVerticalDLUsToPixels(IDialogConstants.VERTICAL_MARGIN);
		layout.marginWidth = convertHorizontalDLUsToPixels(IDialogConstants.HORIZONTAL_MARGIN);
		layout.verticalSpacing = convertVerticalDLUsToPixels(IDialogConstants.VERTICAL_SPACING);
		layout.horizontalSpacing = convertHorizontalDLUsToPixels(IDialogConstants.HORIZONTAL_SPACING);
		userComp.setLayout(layout);

		GridData gd = new GridData(GridData.FILL_BOTH);
		gd.verticalIndent = 5;
		userComp.setLayoutData(gd);
		userComp.setFont(parentComposite.getFont());

		Label label = new Label(userComp, SWT.NONE);
		gd = new GridData(GridData.BEGINNING);
		label.setLayoutData(gd);
		label.setText(Messages.CreateFolderDialog_3);

		text = new Text(userComp, SWT.BORDER);
		gd = new GridData(GridData.FILL_HORIZONTAL);
		gd.horizontalIndent = 10;
		text.setLayoutData(gd);
		
		setHelpAvailable(false);
		Dialog.applyDialogFont(parentComposite);
		return parentComposite;
	}

	@Override
	protected void okPressed() {
		if (text.getText().equals("")) { //$NON-NLS-1$
			MessageDialog.openInformation(getShell(), Messages.NewImportDialog_8, Messages.NewImportDialog_9);
		} else {
			folderName = text.getText();
		}
		super.okPressed();
	}

	public String getFolderName() {
		return folderName;
	}
}
