/*******************************************************************************
 * Copyright (c) 2022, MounRiver Studio
 * All rights reserved. This program and the accompanying materials
 * are made available under the terms of the Eclipse Public License v1.0
 * which accompanies this distribution, and is available at
 * http://www.eclipse.org/legal/epl-v10.html
 *
 * Contributors:
 *    MounRiver Studio  - initial API and implementation
 *******************************************************************************/
package wizard;

import java.io.BufferedOutputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.util.Enumeration;
import java.util.zip.ZipEntry;
import java.util.zip.ZipFile;
import java.util.zip.ZipOutputStream;

import org.eclipse.jface.dialogs.MessageDialog;

public class FileTool {
	public static boolean decompress(String zipPath) {
		int count = -1;
		int buffer = 2048;
		String savepath = "";
		File file = null;
		InputStream is = null;
		FileOutputStream fos = null;
		BufferedOutputStream bos = null;
		savepath = zipPath.substring(0, zipPath.lastIndexOf(".")) + File.separator; // ѹļĿ¼
		new File(savepath).mkdir(); // Ŀ¼
		ZipFile zipFile = null;
		try {
			zipFile = new ZipFile(zipPath); // 
			Enumeration<?> entries = zipFile.entries();
			while (entries.hasMoreElements()) {
				byte buf[] = new byte[buffer];
				ZipEntry entry = (ZipEntry) entries.nextElement();
				String filename = entry.getName();
				boolean ismkdir = false;
				if (filename.lastIndexOf("/") != -1) { // ļǷļ
					ismkdir = true;
				}
				filename = savepath + filename;
				if (entry.isDirectory()) { // ļȴ
					file = new File(filename);
					file.mkdirs();
					continue;
				}
				file = new File(filename);
				if (!file.exists()) { // Ŀ¼ȴ
					if (ismkdir) {
						new File(filename.substring(0, filename.lastIndexOf("/"))).mkdirs(); // Ŀ¼ȴ
					}
				} else {
					if(!MessageDialog.openQuestion(null, "Question", file + " already exists. Whether to overlap?")) {
						return false;
					}
				}
				file.createNewFile(); // ļ
				is = zipFile.getInputStream(entry);
				fos = new FileOutputStream(file);
				bos = new BufferedOutputStream(fos, buffer);
				while ((count = is.read(buf)) > -1) {
					bos.write(buf, 0, count);
				}
				bos.flush();
				bos.close();
				fos.close();
				is.close();
			}
			zipFile.close();
		} catch (IOException ioe) {
			ioe.printStackTrace();
		} finally {
			try {
				if (bos != null) {
					bos.close();
				}
				if (fos != null) {
					fos.close();
				}
				if (is != null) {
					is.close();
				}
				if (zipFile != null) {
					zipFile.close();
				}
			} catch (Exception e) {
				e.printStackTrace();
			}
		}
		return true;
	}

	/**
	 * @param sourcePath Ҫѹļ·
	 * @param suffix     ɵĸʽziprar
	 */
	public static void compress(String sourcePath, String suffix) throws Exception {

		File file = new File(sourcePath);
		// ѹļ·
		if (!file.exists()) {
			throw new Exception("· " + sourcePath + " ļ޷ѹ...");
		}
		// Ŀѹļ
		String generateFileName = file.getParent() + File.separator + file.getName() + "." + suffix;

		//  ʾһԴȡ
		//  ʾһĿд

		// 
		FileOutputStream outputStream = new FileOutputStream(generateFileName);

		// ѹ
		ZipOutputStream zipOutputStream = new ZipOutputStream(new BufferedOutputStream(outputStream));

		compress(zipOutputStream, file, "");

		System.out.println("Դļλã" + file.getAbsolutePath() + "Ŀѹļλã" + generateFileName);
		// ر 
		zipOutputStream.closeEntry();
		zipOutputStream.close();
		outputStream.close();
		zipOutputStream = null;
		outputStream = null;
		System.gc();
	}

	/**
	 * @param out  
	 * @param file Ŀļ
	 * @param dir  ļ
	 * @throws Exception
	 */
	private static void compress(ZipOutputStream out, File file, String dir) throws Exception {

		// ǰļУһ
		if (file.isDirectory()) {
			// õļбϢ
			File[] files = file.listFiles();

			// ļӵһĿ¼
			out.putNextEntry(new ZipEntry(dir + "/"));

			dir = dir.length() == 0 ? "" : dir + "/";

			// ѭļеļ
			for (int i = 0; i < files.length; i++) {
				compress(out, files[i], dir + files[i].getName());
			}
			file.delete();
		} else { // ǰļ

			// 
			FileInputStream inputStream = new FileInputStream(file);
			// ҪĿ
			out.putNextEntry(new ZipEntry(dir));
			// д
			int len = 0;
			byte[] bytes = new byte[1024];
			while ((len = inputStream.read(bytes)) > 0) {
				out.write(bytes, 0, len);
			}
			// ر
			inputStream.close();
			inputStream = null;
			file.delete();
		}
	}

	public static boolean deleteFolder(String sPath) {
		boolean flag = false;
		File file = new File(sPath);
		if (!file.exists()) {
			return flag;
		} else {
			if (file.isFile()) {
				return deleteFile(sPath);
			} else {
				return deleteDirectory(sPath);
			}
		}
	}

	public static boolean deleteFile(String sPath) {
		boolean flag = false;
		File file = new File(sPath);
		if (file.exists() && file.isFile()) {
			file.delete();
			flag = true;
		}
		return flag;
	}

	public static boolean deleteDirectory(String sPath) {
		if (!sPath.endsWith(File.separator)) {
			sPath += File.separator;
		}
		File dirFile = new File(sPath);
		if (!dirFile.exists() || !dirFile.isDirectory()) {
			return false;
		}
		boolean flag = true;
		File[] files = dirFile.listFiles();
		for (int i = 0; i < files.length; i++) {
			if (files[i].isFile()) {
				flag = deleteFile(files[i].getAbsolutePath());
			} else {
				flag = deleteDirectory(files[i].getAbsolutePath());
				if (!flag)
					break;
			}
		}
		if (!flag)
			return false;
		if (dirFile.delete()) {
			return true;
		} else {
			return false;
		}
	}
}
