/*******************************************************************************
 * Copyright (c) 2022, MounRiver Studio
 * All rights reserved. This program and the accompanying materials
 * are made available under the terms of the Eclipse Public License v1.0
 * which accompanies this distribution, and is available at
 * http://www.eclipse.org/legal/epl-v10.html
 *
 * Contributors:
 *    MounRiver Studio  - initial API and implementation
 *******************************************************************************/
package wizard;

import org.eclipse.jface.dialogs.Dialog;
import org.eclipse.swt.SWT;
import org.eclipse.swt.browser.Browser;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Shell;

public class NewPackageDialog extends Dialog {

	protected NewPackageDialog(Shell parentShell) {
		super(parentShell);
		setShellStyle(getShellStyle() | SWT.MAX);

		System.setProperty("org.eclipse.swt.browser.DefaultType", "mozilla");
		System.setProperty("org.eclipse.swt.browser.XULRunnerPath",
				"C:\\MounRiver\\MounRiver_Studio\\xulrunner-10.0.4esr.en-US.win32.sdk\\xulrunner-sdk\\bin\\xulrunner.exe");
	}

	protected void configureShell(Shell shell) {
		super.configureShell(shell);
		shell.setSize(1233, 880);
	}

	@Override
	protected Control createDialogArea(Composite parent) {
		// top level composite
		Composite parentComposite = (Composite) super.createDialogArea(parent);

		// create a composite with standard margins and spacing
		Composite userComp = new Composite(parentComposite, SWT.FILL);
		GridLayout layout = new GridLayout();

		userComp.setLayout(layout);
		userComp.setLayoutData(new GridData(GridData.FILL_BOTH));
		userComp.setFont(parentComposite.getFont());

		Browser browser = new Browser(userComp, SWT.MOZILLA);
		GridData gd = new GridData(GridData.FILL_BOTH);
		browser.setLayoutData(gd);
		browser.setUrl("http://192.168.111.71:3030");
//		browser.setUrl("https://ie.icoa.cn");
		Dialog.applyDialogFont(parentComposite);
		return parentComposite;
	}

	@Override
	protected void createButtonsForButtonBar(Composite parent) {
	}

}
