/*******************************************************************************
 * Copyright (c) 2022, MounRiver Studio
 * All rights reserved. This program and the accompanying materials
 * are made available under the terms of the Eclipse Public License v1.0
 * which accompanies this distribution, and is available at
 * http://www.eclipse.org/legal/epl-v10.html
 *
 * Contributors:
 *    MounRiver Studio  - initial API and implementation
 *******************************************************************************/
package wizard;

import java.net.MalformedURLException;

import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.jface.window.Window;
import org.eclipse.jface.wizard.Wizard;
import org.eclipse.ui.INewWizard;
import org.eclipse.ui.IWorkbench;
import org.eclipse.ui.IWorkbenchWindow;
import org.eclipse.ui.PartInitException;
import org.eclipse.ui.PlatformUI;
import org.eclipse.ui.browser.IWorkbenchBrowserSupport;

public class NewPackageWizard extends Wizard implements INewWizard {
	private IWorkbenchWindow fWindow;
	private static final String URL = "http://192.168.111.71:3030";

	@Override
	public void init(IWorkbench workbench, IStructuredSelection selection) {
		fWindow = workbench.getActiveWorkbenchWindow();
	}

	@Override
	public boolean performFinish() {
		// use external browser
		IWorkbenchBrowserSupport support = PlatformUI.getWorkbench().getBrowserSupport();
		try {
			
			support.getExternalBrowser().openURL(new java.net.URL(URL));
		} catch (PartInitException e) {
			e.printStackTrace();
		} catch (MalformedURLException e) {
			e.printStackTrace();
		}
		return true;
	
		// Use SWT.BROWSER to load url
//		NewPackageDialog newPackageDialog = new NewPackageDialog(fWindow.getShell());
//		if(Window.OK == newPackageDialog.open()) {
//			
//		}
//		return true;
	}
}
