/*******************************************************************************
 * Copyright (c) 2022, MounRiver Studio
 * All rights reserved. This program and the accompanying materials
 * are made available under the terms of the Eclipse Public License v1.0
 * which accompanies this distribution, and is available at
 * http://www.eclipse.org/legal/epl-v10.html
 *
 * Contributors:
 *    MounRiver Studio  - initial API and implementation
 *******************************************************************************/
package wizard;

import org.eclipse.core.runtime.preferences.ConfigurationScope;
import org.eclipse.jface.dialogs.Dialog;
import org.eclipse.jface.dialogs.MessageDialog;
import org.eclipse.jface.dialogs.TitleAreaDialog;
import org.eclipse.swt.SWT;
import org.eclipse.swt.events.SelectionAdapter;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.DirectoryDialog;
import org.eclipse.swt.widgets.FileDialog;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.swt.widgets.Text;
import org.eclipse.ui.forms.widgets.FormToolkit;
import org.eclipse.ui.forms.widgets.Section;
import org.eclipse.ui.preferences.ScopedPreferenceStore;

public class NewSolutionDialog extends TitleAreaDialog {
	private static final String EMPTY_STR = "";
	private final String headerTitle;

	private final String message;
	private String title;
	private String filePath = EMPTY_STR; // $NON-NLS-1$

	private String buildToolsPath;
	private String armTcPath;
	private String rvTcPath;
	private String openocdPath;
	private String openocdName;

	private Label label;

	private Text text;
	private Text textBuildTools;
	private Text textARM;
	private Text textRV;
	private Text textOpenocdName;
	private Text textOpenocdPath;

	private Button btnBrowse;
	private Button btnBrowseBuildTools;
	private Button btnBrowseARM;
	private Button btnBrowseRV;
	private Button btnBrowseOpenocd;

	public NewSolutionDialog(Shell parentShell) {
		this(parentShell, Messages.NewSolutionDialog_0, Messages.NewSolutionDialog_0, Messages.NewSolutionDialog_2); // $NON-NLS-1$
		setShellStyle(getShellStyle() | SWT.SHEET);
	}

	public NewSolutionDialog(Shell parentShell, String title, String headerTitle, String message) {
		super(parentShell);
		this.title = title;
		this.headerTitle = headerTitle;
		this.message = message;
	}

	protected void configureShell(Shell shell) {
		super.configureShell(shell);
		shell.setText(this.title);
	}

	@Override

	protected Control createDialogArea(Composite parent) {
		setTitle(this.headerTitle);
		setMessage(this.message);
		// top level composite
		Composite parentComposite = (Composite) super.createDialogArea(parent);
		// create a composite with standard margins and spacing
		Composite userComp = new Composite(parentComposite, SWT.FILL);

		GridLayout layout = new GridLayout(3, false);
//		layout.marginHeight = convertVerticalDLUsToPixels(IDialogConstants.VERTICAL_MARGIN);
//		layout.marginWidth = convertHorizontalDLUsToPixels(IDialogConstants.HORIZONTAL_MARGIN);
//		layout.verticalSpacing = convertVerticalDLUsToPixels(IDialogConstants.VERTICAL_SPACING);
//		layout.horizontalSpacing = convertHorizontalDLUsToPixels(IDialogConstants.HORIZONTAL_SPACING);
		
		userComp.setLayout(layout);
		userComp.setLayoutData(new GridData(GridData.FILL_BOTH));
		userComp.setFont(parentComposite.getFont());

		FormToolkit toolkit = new FormToolkit(parent.getDisplay());
		Section section = toolkit.createSection(userComp, 450);
		section.setText("New Solution Path");
	    GridData gd = new GridData(GridData.FILL_BOTH);
	    gd.horizontalSpan = 3;
	    section.setLayoutData(gd);
	    
	    Composite composite = toolkit.createComposite(section);
	    composite.setLayoutData(new GridData(GridData.FILL_BOTH));
	    composite.setLayout(new GridLayout(3, false));
	    section.setClient(composite);
		
		label = new Label(composite, SWT.NONE);
		gd = new GridData();
		label.setLayoutData(gd);
		label.setText("New Solution Path:"); //$NON-NLS-1$

		text = new Text(composite, SWT.BORDER | SWT.READ_ONLY);
		gd = new GridData(GridData.FILL_HORIZONTAL);
		text.setLayoutData(gd);

		btnBrowse = new Button(composite, SWT.PUSH);
		btnBrowse.setText(Messages.NewSolutionDialog_4);
		gd = new GridData();
		btnBrowse.setLayoutData(gd);
		btnBrowse.addSelectionListener(new SelectionAdapter() {
			@Override
			public void widgetSelected(SelectionEvent e) {
				FileDialog fileDialog = new FileDialog(getShell(), SWT.SAVE);
				fileDialog.setText(Messages.NewSolutionWizard_0);
				fileDialog.setFilterExtensions(new String[] { "*.wvsln" }); //$NON-NLS-1$
				fileDialog.setFilterNames(new String[] { "MRS Solotion(*.wvsln)" }); //$NON-NLS-1$
//				fileDialog.setFileName(".wvsln");
				String savePath = fileDialog.open();
				if (savePath != null) {
					text.setText(savePath);
					text.setToolTipText(savePath);
				}
			}
		});

		FormToolkit toolkit2 = new FormToolkit(parent.getDisplay());
		Section section2 = toolkit2.createSection(userComp, 450);
		section2.setText("OpenOCD");
	    gd = new GridData(GridData.FILL_BOTH);
	    gd.horizontalSpan = 3;
	    section2.setLayoutData(gd);
	    
	    Composite composite2 = toolkit2.createComposite(section2);
	    composite2.setLayoutData(new GridData(GridData.FILL_BOTH));
	    composite2.setLayout(new GridLayout(3, false));
	    section2.setClient(composite2);
		
		// workspace openocd
		Label labelOpenocdName = new Label(composite2, SWT.NONE);
		gd = new GridData();
		labelOpenocdName.setLayoutData(gd);
		labelOpenocdName.setText("OpenOCD Name:"); //$NON-NLS-1$

		textOpenocdName = new Text(composite2, SWT.BORDER);
		gd = new GridData(GridData.FILL_HORIZONTAL);
		textOpenocdName.setLayoutData(gd);
		ScopedPreferenceStore scopedPreferenceStore2 = new ScopedPreferenceStore(ConfigurationScope.INSTANCE,
				"ilg.gnumcueclipse.debug.gdbjtag.openocd");

		String globalOpenocdName = scopedPreferenceStore2.getString("executable.name");
		textOpenocdName.setText(globalOpenocdName);
		textOpenocdName.setToolTipText(globalOpenocdName);

		Label empty = new Label(composite2, SWT.NONE);
		gd = new GridData();
		empty.setLayoutData(gd);
		empty.setText(EMPTY_STR); // $NON-NLS-1$

		Label labelOpenocd = new Label(composite2, SWT.NONE);
		gd = new GridData();
		labelOpenocd.setLayoutData(gd);
		labelOpenocd.setText("OpenOCD Path:"); //$NON-NLS-1$

		textOpenocdPath = new Text(composite2, SWT.BORDER | SWT.READ_ONLY);
		gd = new GridData(GridData.FILL_HORIZONTAL);
		textOpenocdPath.setLayoutData(gd);
		String globalOpenocdPath = scopedPreferenceStore2.getString("install.folder");
		textOpenocdPath.setText(globalOpenocdPath);
		textOpenocdPath.setToolTipText(globalOpenocdPath);

		btnBrowseOpenocd = new Button(composite2, SWT.PUSH);
		btnBrowseOpenocd.setText(Messages.NewSolutionDialog_4); // $NON-NLS-1$
		gd = new GridData();
		btnBrowseOpenocd.setLayoutData(gd);
		btnBrowseOpenocd.addSelectionListener(new SelectionAdapter() {
			@Override
			public void widgetSelected(SelectionEvent e) {
				DirectoryDialog directoryDialog = new DirectoryDialog(getShell());
				directoryDialog.setText(Messages.NewSolutionWizard_0);

				String path = directoryDialog.open();
				if (path != null) {
					textOpenocdPath.setText(path);
					textOpenocdPath.setToolTipText(path);
				}
			}
		});

		FormToolkit toolkit3 = new FormToolkit(parent.getDisplay());
		Section section3 = toolkit3.createSection(userComp, 450);
		section3.setText("Build Tool");
	    gd = new GridData(GridData.FILL_BOTH);
	    gd.horizontalSpan = 3;
	    section3.setLayoutData(gd);
	    
	    Composite composite3 = toolkit3.createComposite(section3);
	    composite3.setLayoutData(new GridData(GridData.FILL_BOTH));
	    composite3.setLayout(new GridLayout(3, false));
	    section3.setClient(composite3);
	    
		// build tools
		Label labelBuildTool = new Label(composite3, SWT.NONE);
		gd = new GridData();
		labelBuildTool.setLayoutData(gd);
		labelBuildTool.setText("Build Tools Path:"); //$NON-NLS-1$

		textBuildTools = new Text(composite3, SWT.BORDER | SWT.READ_ONLY);
		ScopedPreferenceStore scopedPreferenceStore = new ScopedPreferenceStore(ConfigurationScope.INSTANCE,
				"ilg.gnumcueclipse.managedbuild.cross");
		String globalBuildPath = scopedPreferenceStore.getString("buildTools.path");
		textBuildTools.setText(globalBuildPath);
		textBuildTools.setToolTipText(globalBuildPath);
		gd = new GridData(GridData.FILL_HORIZONTAL);
		textBuildTools.setLayoutData(gd);

		btnBrowseBuildTools = new Button(composite3, SWT.PUSH);
		btnBrowseBuildTools.setText(Messages.NewSolutionDialog_4); // $NON-NLS-1$
		gd = new GridData();
		btnBrowseBuildTools.setLayoutData(gd);
		btnBrowseBuildTools.addSelectionListener(new SelectionAdapter() {
			@Override
			public void widgetSelected(SelectionEvent e) {
				DirectoryDialog directoryDialog = new DirectoryDialog(getShell());
				directoryDialog.setText(Messages.NewSolutionWizard_0);
				String path = directoryDialog.open();
				if (path != null) {
					textBuildTools.setText(path);
					textBuildTools.setToolTipText(path);
				}
			}
		});


		FormToolkit toolkit4 = new FormToolkit(parent.getDisplay());
		Section section4 = toolkit4.createSection(userComp, 450);
		section4.setText("Toolchain");
	    gd = new GridData(GridData.FILL_BOTH);
	    gd.horizontalSpan = 3;
	    section4.setLayoutData(gd);
	    
	    Composite composite4 = toolkit4.createComposite(section4);
	    composite4.setLayoutData(new GridData(GridData.FILL_BOTH));
	    composite4.setLayout(new GridLayout(3, false));
	    section4.setClient(composite4);
	    
		// workspace arm toolchain
		Label labelARM = new Label(composite4, SWT.NONE);
		gd = new GridData();
		labelARM.setLayoutData(gd);
		labelARM.setText("ARM Toolchain:"); //$NON-NLS-1$

		textARM = new Text(composite4, SWT.BORDER | SWT.READ_ONLY);
		gd = new GridData(GridData.FILL_HORIZONTAL);
		textARM.setLayoutData(gd);
//		String globalArmPath = new PersistentPreferences("ilg.gnumcueclipse.managedbuild.cross.arm")
//				.getToolchainPath("GNU MCU Eclipse ARM Embedded GCC", null);
		ScopedPreferenceStore scopedPreferenceStore0 = new ScopedPreferenceStore(ConfigurationScope.INSTANCE,
				"ilg.gnumcueclipse.managedbuild.cross.arm");

		String globalArmPath = scopedPreferenceStore0.getString("toolchain.path.962691777");
		textARM.setText(globalArmPath);
		textARM.setToolTipText(globalArmPath);

		btnBrowseARM = new Button(composite4, SWT.PUSH);
		btnBrowseARM.setText(Messages.NewSolutionDialog_4); // $NON-NLS-1$
		gd = new GridData();
		btnBrowseARM.setLayoutData(gd);
		btnBrowseARM.addSelectionListener(new SelectionAdapter() {
			@Override
			public void widgetSelected(SelectionEvent e) {
				DirectoryDialog directoryDialog = new DirectoryDialog(getShell());
				directoryDialog.setText(Messages.NewSolutionWizard_0);
				String path = directoryDialog.open();
				if (path != null) {
					textARM.setText(path);
					textARM.setToolTipText(path);
				}
			}
		});

		// workspace risc-v toolchain
		Label labelRV = new Label(composite4, SWT.NONE);
		gd = new GridData();
		labelRV.setLayoutData(gd);
		labelRV.setText("RISC-V Toolchain"); //$NON-NLS-1$

		textRV = new Text(composite4, SWT.BORDER | SWT.READ_ONLY);
		gd = new GridData(GridData.FILL_HORIZONTAL);
		textRV.setLayoutData(gd);
//		String globalRvPath = new PersistentPreferences("ilg.gnumcueclipse.managedbuild.cross.riscv")
//				.getToolchainPath("GNU MCU RISC-V GCC", null);

		ScopedPreferenceStore scopedPreferenceStore3 = new ScopedPreferenceStore(ConfigurationScope.INSTANCE,
				"ilg.gnumcueclipse.managedbuild.cross.riscv");
		String globalRvPath = scopedPreferenceStore3.getString("toolchain.path.512258282");
		textRV.setText(globalRvPath);
		textRV.setToolTipText(globalRvPath);

		btnBrowseRV = new Button(composite4, SWT.PUSH);
		btnBrowseRV.setText(Messages.NewSolutionDialog_4); // $NON-NLS-1$
		gd = new GridData();
		btnBrowseRV.setLayoutData(gd);
		btnBrowseRV.addSelectionListener(new SelectionAdapter() {
			@Override
			public void widgetSelected(SelectionEvent e) {
				DirectoryDialog directoryDialog = new DirectoryDialog(getShell());
				directoryDialog.setText(Messages.NewSolutionWizard_0);

				String path = directoryDialog.open();
				if (path != null) {
					textRV.setText(path);
					textRV.setToolTipText(path);
				}
			}
		});

		setHelpAvailable(false);
		Dialog.applyDialogFont(parentComposite);
		return parentComposite;
	}

	@Override

	protected void okPressed() {
		if (text.getText().equals("")) { //$NON-NLS-1$
			MessageDialog.openWarning(getShell(), Messages.NewSolutionDialog_13, Messages.NewSolutionDialog_14);
			return;
		} else {
			filePath = text.getText();
		}

		buildToolsPath = textBuildTools.getText();
		armTcPath = textARM.getText();
		rvTcPath = textRV.getText();
		openocdPath = textOpenocdPath.getText();
		openocdName = textOpenocdName.getText();

		super.okPressed();

	}

	public String getFilePath() {
		return filePath;
	}

	@Override

	public void setMessage(String newMessage) {
		super.setMessage(newMessage);

	}

	public String getBuildToolsPath() {
		return buildToolsPath;
	}

	public String getArmTcPath() {
		return armTcPath;
	}

	public String getRvTcPath() {
		return rvTcPath;
	}

	public String getOpenocdPath() {
		return openocdPath;
	}

	public String getOpenocdName() {
		return openocdName;
	}
}
