/*******************************************************************************
 * Copyright (c) 2022, MounRiver Studio
 * All rights reserved. This program and the accompanying materials
 * are made available under the terms of the Eclipse Public License v1.0
 * which accompanies this distribution, and is available at
 * http://www.eclipse.org/legal/epl-v10.html
 *
 * Contributors:
 *    MounRiver Studio  - initial API and implementation
 *******************************************************************************/
package wizard;

import org.eclipse.jface.layout.GridLayoutFactory;
import org.eclipse.jface.layout.LayoutConstants;
import org.eclipse.jface.wizard.WizardPage;
import org.eclipse.swt.SWT;
import org.eclipse.swt.events.ModifyEvent;
import org.eclipse.swt.events.ModifyListener;
import org.eclipse.swt.graphics.Point;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Text;

public class NewWizardPage3 extends WizardPage {
	private Text textRamLen;
	private Text textRamAddr;
	private Text textFlashLen;
	private Text textFlashAddr;
	private Text textStackSize;

	protected NewWizardPage3(String pageName) {
		super(pageName);
		setTitle(pageName);
		setDescription("Modify Flash and RAM propeties which adapt to hardware enviroment");
		setPageComplete(false);
	}

	@Override
	public void createControl(Composite parent) {
		Composite userComp = new Composite(parent, SWT.FILL);
		setControl(userComp);
		GridData gd = new GridData(768);
		GridLayout topLayout = new GridLayout(2, false);
		userComp.setLayout(topLayout);
		userComp.setLayoutData(gd);
		Label labelStackSize = new Label(userComp, SWT.NONE);
		labelStackSize.setText("Stack Size:");
		textStackSize = new Text(userComp, SWT.BORDER);
		textStackSize.setText("");
		textStackSize.selectAll();
		textStackSize.setLayoutData(new GridData(GridData.FILL_HORIZONTAL));

		Label labelFlashAddr = new Label(userComp, SWT.NONE);
		labelFlashAddr.setText("Flash Address:");
		textFlashAddr = new Text(userComp, SWT.BORDER);
		textFlashAddr.setText("");
		textFlashAddr.selectAll();
		textFlashAddr.setLayoutData(new GridData(GridData.FILL_HORIZONTAL));

		Label labelFlashLen = new Label(userComp, SWT.NONE);
		labelFlashLen.setText("Flash Length:");
		textFlashLen = new Text(userComp, SWT.BORDER);
		textFlashLen.setText("");
		textFlashLen.selectAll();
		textFlashLen.setLayoutData(new GridData(GridData.FILL_HORIZONTAL));

		Label labelRamAddr = new Label(userComp, SWT.NONE);
		labelRamAddr.setText("RAM Address:");
		textRamAddr = new Text(userComp, SWT.BORDER);
		textRamAddr.setText("");
		textRamAddr.selectAll();
		textRamAddr.setLayoutData(new GridData(GridData.FILL_HORIZONTAL));

		Label labelRamLen = new Label(userComp, SWT.NONE);
		labelRamLen.setText("RAM Length:");
		textRamLen = new Text(userComp, SWT.BORDER);
		textRamLen.setText("");
		textRamLen.selectAll();
		textRamLen.setLayoutData(new GridData(GridData.FILL_HORIZONTAL));

		addListeners();
		Point defaultMargins = LayoutConstants.getMargins();
		GridLayoutFactory.fillDefaults().numColumns(2).margins(defaultMargins.x, defaultMargins.y)
				.generateLayout(userComp);

	}

	private void addListeners() {
		textStackSize.addModifyListener(new ModifyListener() {

			@Override
			public void modifyText(ModifyEvent e) {
				updateComplete();
			}
		});

		textFlashAddr.addModifyListener(new ModifyListener() {

			@Override
			public void modifyText(ModifyEvent e) {
				updateComplete();
			}
		});

		textFlashLen.addModifyListener(new ModifyListener() {

			@Override
			public void modifyText(ModifyEvent e) {
				updateComplete();
			}
		});

		textRamAddr.addModifyListener(new ModifyListener() {

			@Override
			public void modifyText(ModifyEvent e) {
				updateComplete();
			}
		});

		textRamLen.addModifyListener(new ModifyListener() {

			@Override
			public void modifyText(ModifyEvent e) {
				updateComplete();
			}
		});
	}

	private void updateComplete() {
		setPageComplete(!textStackSize.getText().isEmpty() && !textFlashAddr.getText().isEmpty()
				&& !textFlashLen.getText().isEmpty() && !textRamAddr.getText().isEmpty()
				&& !textRamLen.getText().isEmpty());
	}
}
