/*******************************************************************************
 * Copyright (c) 2022, MounRiver Studio
 * All rights reserved. This program and the accompanying materials
 * are made available under the terms of the Eclipse Public License v1.0
 * which accompanies this distribution, and is available at
 * http://www.eclipse.org/legal/epl-v10.html
 *
 * Contributors:
 *    MounRiver Studio  - initial API and implementation
 *******************************************************************************/
package wizard;

import java.io.File;

import org.eclipse.core.resources.IProject;
import org.eclipse.core.resources.ResourcesPlugin;

public class ProjectUtil {
	public static boolean isProjectHasExist(String name) {
		IProject project = ResourcesPlugin.getWorkspace().getRoot().getProject(name);
		if (project != null && project.exists()) {
			return true;
		}
		return false;
	}

	public static boolean isSpecificDirectoryExist(String path) {
		File file = new File(path);
		return file.exists();
	}

	public static boolean isValidTemplate(String name) {
		return name != null && !name.isEmpty() && name.endsWith(".zip");
	}

}
