/*******************************************************************************
 * Copyright (c) 2022, MounRiver Studio
 * All rights reserved. This program and the accompanying materials
 * are made available under the terms of the Eclipse Public License v1.0
 * which accompanies this distribution, and is available at
 * http://www.eclipse.org/legal/epl-v10.html
 *
 * Contributors:
 *    MounRiver Studio  - initial API and implementation
 *******************************************************************************/
package xmlbean;

import java.util.ArrayList;
import java.util.List;

public class EclipseInfoEntry {
	private List<String> assembleIncludePaths;
	
	private List<String> compilerDefines;
	private List<String> compilerIncludePaths;
	
	private String linkerGeneral;
	private String linkerLibraries;
	
	private boolean parallelBuild=true;
	
	public EclipseInfoEntry() {
		assembleIncludePaths=new ArrayList<String>();
		compilerIncludePaths=new ArrayList<String>();
		compilerDefines=new ArrayList<String>();
	}
	
	public void setAssembleIncludePaths(String assembleIncludePaths) {
		this.assembleIncludePaths.add(assembleIncludePaths);
	}
	
	public void setCompilerDefines(String compilerDefine) {
		this.compilerDefines.add(compilerDefine);
	}
	
	public void setCompilerIncludePaths(String compilerIncludePaths) {
		this.compilerIncludePaths.add(compilerIncludePaths);
	}
	
	public List<String> getAssembleIncludePaths() {
		return assembleIncludePaths;
	}

	public void setAssembleIncludePaths(List<String> assembleIncludePaths) {
		this.assembleIncludePaths = assembleIncludePaths;
	}

	public List<String> getCompilerIncludePaths() {
		return compilerIncludePaths;
	}
	
	public List<String> getCompilerDefines() {
		return compilerDefines;
	}

	public void setCompilerIncludePaths(List<String> compilerIncludePaths) {
		this.compilerIncludePaths = compilerIncludePaths;
	}

	public String getLinkerGeneral() {
		return linkerGeneral;
	}
	public void setLinkerGeneral(String linkerGeneral) {
		this.linkerGeneral = linkerGeneral;
	}
	public String getLinkerLibraries() {
		return linkerLibraries;
	}
	public void setLinkerLibraries(String linkerLibraries) {
		this.linkerLibraries = linkerLibraries;
	}

	public boolean isParallelBuild() {
		return parallelBuild;
	}

	public void setParallelBuild(boolean parallelBuild) {
		this.parallelBuild = parallelBuild;
	}
	
	

}
