/*******************************************************************************
 * Copyright (c) 2022, MounRiver Studio
 * All rights reserved. This program and the accompanying materials
 * are made available under the terms of the Eclipse Public License v1.0
 * which accompanies this distribution, and is available at
 * http://www.eclipse.org/legal/epl-v10.html
 *
 * Contributors:
 *    MounRiver Studio  - initial API and implementation
 *******************************************************************************/
package xmlbean;

import java.util.ArrayList;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;

public class Element {
	
	//property
	private String name;
	private String value;
	
	
	private Map<String, String> attributes;
	
	private List<Element> children;
	
	
	public Element() {
		attributes=new LinkedHashMap<>();
		children=new ArrayList<>();
	}
	
	public Element(String name) {
		this();
		this.name=name;
	}
	
	public void setAttribute(String name,String value) {
		attributes.put(name, value);
	}
	
	public Element addChild(Element element) {
		children.add(element);
		return this;
	}
	
	public Element addChildren(Element... element) {
		for (int i = 0; i < element.length; i++) {
			children.add(element[i]);
		}
		return this;
	}

	public String getName() {
		return name;
	}

	public void setName(String name) {
		this.name = name;
	}

	public String getValue() {
		return value;
	}

	public void setValue(String value) {
		this.value = value;
	}

	public Map<String, String> getAttributes() {
		return attributes;
	}

	public List<Element> getChildren() {
		return children;
	}
	
	
	
	
	
	
}
