/********************************** (C) COPYRIGHT *******************************
* File Name          : CH56x_uart.h
* Author             : WCH
* Version            : V1.0
* Date               : 2020/07/31
* Description
* Copyright (c) 2021 Nanjing Qinheng Microelectronics Co., Ltd.
* SPDX-License-Identifier: Apache-2.0
*******************************************************************************/


#ifndef __CH56x_UART_H__
#define __CH56x_UART_H__

#ifdef __cplusplus
 extern "C" {
#endif


/** 
  * @brief	·״̬
  */     
#define  STA_ERR_BREAK      RB_LSR_BREAK_ERR       // ݼ     
#define  STA_ERR_FRAME      RB_LSR_FRAME_ERR       // ֡     
#define  STA_ERR_PAR        RB_LSR_PAR_ERR         // żУλ
#define  STA_ERR_FIFOOV     RB_LSR_OVER_ERR        //   
     
#define  STA_TXFIFO_EMP     RB_LSR_TX_FIFO_EMP     // ǰFIFOգԼ䷢
#define  STA_TXALL_EMP      RB_LSR_TX_ALL_EMP      // ǰзݶ     
#define  STA_RECV_DATA      RB_LSR_DATA_RDY        // ǰнյ


/**
  * @brief  ֽڴ
  */     
typedef enum
{
	UART_1BYTE_TRIG = 0,        // 1ֽڴ
	UART_2BYTE_TRIG = 1,            // 2ֽڴ
	UART_4BYTE_TRIG = 2,            // 4ֽڴ
	UART_7BYTE_TRIG = 3 ,            // 7ֽڴ
	
}UARTByteTRIGTypeDef;     
 
 
/****************** UART0 */ 
void UART0_DefInit( void );	 							/* Ĭϳʼ */
void UART0_BaudRateCfg( UINT32 baudrate );	 			/* ڲ */
void UART0_ByteTrigCfg( UARTByteTRIGTypeDef b );        /* ֽڴж */
void UART0_INTCfg( UINT8 s,  UINT8 i );		            /* ж */
void UART0_Reset( void );								/* λ */

#define UART0_CLR_RXFIFO()       (R8_UART0_FCR |= RB_FCR_RX_FIFO_CLR)          /* ǰFIFO */
#define UART0_CLR_TXFIFO()       (R8_UART0_FCR |= RB_FCR_TX_FIFO_CLR)          /* ǰFIFO */

#define UART0_GetITFlag()       (R8_UART0_IIR & RB_IIR_INT_MASK)          /* ȡǰжϱ־ */
// please refer to LINE error and status define
#define UART0_GetLinSTA()       (R8_UART0_LSR)          /* ȡǰͨѶ״̬ */
#define UART0_GetMSRSTA()       (R8_UART0_MSR)          /* ȡǰ״̬UART0 */

#define	UART0_SendByte(b)		(R8_UART0_THR = b)		/* ڵֽڷ */
void UART0_SendString( PUINT8 buf, UINT16 l );			/* ڶֽڷ */
#define	UART0_RecvByte()		( R8_UART0_RBR )        /* ڶȡֽ */
UINT16 UART0_RecvString( PUINT8 buf );					/* ڶȡֽ */

      
/****************** UART1 */ 	 
void UART1_DefInit( void );	 							/* Ĭϳʼ */
void UART1_BaudRateCfg( UINT32 baudrate );	 			/* ڲ */
void UART1_ByteTrigCfg( UARTByteTRIGTypeDef b );        /* ֽڴж */
void UART1_INTCfg( UINT8 s,  UINT8 i );		            /* ж */
void UART1_Reset( void );								/* λ */

#define UART1_CLR_RXFIFO()       (R8_UART1_FCR |= RB_FCR_RX_FIFO_CLR)          /* ǰFIFO */
#define UART1_CLR_TXFIFO()       (R8_UART1_FCR |= RB_FCR_TX_FIFO_CLR)          /* ǰFIFO */

#define UART1_GetITFlag()       (R8_UART1_IIR&RB_IIR_INT_MASK)          /* ȡǰжϱ־ */
// please refer to LINE error and status define
#define UART1_GetLinSTA()       (R8_UART1_LSR)          /* ȡǰͨѶ״̬ */

#define	UART1_SendByte(b)		(R8_UART1_THR = b)		/* ڵֽڷ */
void UART1_SendString( PUINT8 buf, UINT16 l );			/* ڶֽڷ */
#define	UART1_RecvByte()		( R8_UART1_RBR )        /* ڶȡֽ */
UINT16 UART1_RecvString( PUINT8 buf );					/* ڶȡֽ */



/****************** UART2 */ 
void UART2_DefInit( void );	 							/* Ĭϳʼ */
void UART2_BaudRateCfg( UINT32 baudrate );	 			/* ڲ */
void UART2_ByteTrigCfg( UARTByteTRIGTypeDef b );        /* ֽڴж */
void UART2_INTCfg( UINT8 s,  UINT8 i );		            /* ж */
void UART2_Reset( void );								/* λ */

#define UART2_CLR_RXFIFO()       (R8_UART2_FCR |= RB_FCR_RX_FIFO_CLR)          /* ǰFIFO */
#define UART2_CLR_TXFIFO()       (R8_UART2_FCR |= RB_FCR_TX_FIFO_CLR)          /* ǰFIFO */

#define UART2_GetITFlag()       (R8_UART2_IIR&RB_IIR_INT_MASK)          /* ȡǰжϱ־ */
// please refer to LINE error and status define
#define UART2_GetLinSTA()       (R8_UART2_LSR)          /* ȡǰͨѶ״̬ */

#define	UART2_SendByte(b)		(R8_UART2_THR = b)		/* ڵֽڷ */
void UART2_SendString( PUINT8 buf, UINT16 l );			/* ڶֽڷ */
#define	UART2_RecvByte()		( R8_UART2_RBR )        /* ڶȡֽ */
UINT16 UART2_RecvString( PUINT8 buf );					/* ڶȡֽ */


/****************** UART3 */ 
void UART3_DefInit( void );	 							/* Ĭϳʼ */
void UART3_BaudRateCfg( UINT32 baudrate );	 			/* ڲ */
void UART3_ByteTrigCfg( UARTByteTRIGTypeDef b );        /* ֽڴж */
void UART3_INTCfg( UINT8 s,  UINT8 i );		            /* ж */
void UART3_Reset( void );								/* λ */

#define UART3_CLR_RXFIFO()       (R8_UART3_FCR |= RB_FCR_RX_FIFO_CLR)          /* ǰFIFO */
#define UART3_CLR_TXFIFO()       (R8_UART3_FCR |= RB_FCR_TX_FIFO_CLR)          /* ǰFIFO */

#define UART3_GetITFlag()       (R8_UART3_IIR&RB_IIR_INT_MASK)          /* ȡǰжϱ־ */
// please refer to LINE error and status define
#define UART3_GetLinSTA()       (R8_UART3_LSR)          /* ȡǰͨѶ״̬ */

#define	UART3_SendByte(b)		(R8_UART3_THR = b)		/* ڵֽڷ */
void UART3_SendString( PUINT8 buf, UINT16 l );			/* ڶֽڷ */
#define	UART3_RecvByte()		( R8_UART3_RBR )        /* ڶȡֽ */
UINT16 UART3_RecvString( PUINT8 buf );					/* ڶȡֽ */

	 
	 
#ifdef __cplusplus
}
#endif

#endif  // __CH56x_UART_H__	

