/********************************** (C) COPYRIGHT *******************************
* File Name          : CH56x_spi.c
* Author             : WCH
* Version            : V1.0
* Date               : 2020/07/31
* Description 
* Copyright (c) 2021 Nanjing Qinheng Microelectronics Co., Ltd.
* SPDX-License-Identifier: Apache-2.0
*******************************************************************************/

#include "CH56x_common.h"

/*******************************************************************************
 * @fn     SPI0_MasterDefInit
 *
 * @brief  ģʽĬϳʼ
 *
 * @return   None
 */
void SPI0_MasterDefInit( void )
{
    R8_SPI0_CLOCK_DIV = 4;                                   //Ƶʱ4Ƶ
    R8_SPI0_CTRL_MOD = RB_SPI_ALL_CLEAR;                     //FIFO//жϱ־Ĵ0д1ǿջ
    R8_SPI0_CTRL_MOD = RB_SPI_MOSI_OE | RB_SPI_SCK_OE ;      //MOSIźSCKʹ
    R8_SPI0_CTRL_CFG |= RB_SPI_AUTO_IF;                      //ʹܷBUFFER/FIFOԶ־λ
    R8_SPI0_CTRL_CFG &= ~RB_SPI_DMA_ENABLE;                  //DMAʽ
}

/*******************************************************************************
 * @fn     SPI0_DataMode
 *
 * @brief  ģʽ
 *
 * @param  m - ģʽ
 *
 * @return   None
 */
void SPI0_DataMode( ModeBitOrderTypeDef m )
{
    switch( m )
    {
        case Mode0_LowBitINFront:                       //ģʽ0λǰ
            R8_SPI0_CTRL_MOD &= ~RB_SPI_MST_SCK_MOD;
            R8_SPI0_CTRL_CFG |= RB_SPI_BIT_ORDER;
            break;
        case Mode0_HighBitINFront:                      //ģʽ0λǰ
            R8_SPI0_CTRL_MOD &= ~RB_SPI_MST_SCK_MOD;
            R8_SPI0_CTRL_CFG &= ~RB_SPI_BIT_ORDER;
            break;
        case Mode3_LowBitINFront:                       //ģʽ3λǰ
            R8_SPI0_CTRL_MOD |= RB_SPI_MST_SCK_MOD;
            R8_SPI0_CTRL_CFG |= RB_SPI_BIT_ORDER;
            break;
        case Mode3_HighBitINFront:                      //ģʽ3λǰ
            R8_SPI0_CTRL_MOD |= RB_SPI_MST_SCK_MOD;
            R8_SPI0_CTRL_CFG &= ~RB_SPI_BIT_ORDER;
            break;
        default:
            break;
    }
}

/*******************************************************************************
 * @fn     SPI0_MasterSendByte
 *
 * @brief  ͵ֽ(buffer)
 *
 * @param  d - ֽ
 *
 * @return  None
 */
void SPI0_MasterSendByte( UINT8 d )
{
    R8_SPI0_CTRL_MOD &= ~RB_SPI_FIFO_DIR;
    R8_SPI0_BUFFER = d;
    while( !(R8_SPI0_INT_FLAG & RB_SPI_FREE) );
}

/*******************************************************************************
 * @fn     SPI0_MasterRecvByte
 *
 * @brief  յֽ (buffer)
 *
 * @return   յֽ
 */
UINT8 SPI0_MasterRecvByte( void )
{
    R8_SPI0_CTRL_MOD &= ~RB_SPI_FIFO_DIR;
    R8_SPI0_BUFFER = 0xFF;                                //
    while( !(R8_SPI0_INT_FLAG & RB_SPI_FREE) );
    return ( R8_SPI0_BUFFER );
}

/*******************************************************************************
 * @fn     SPI0_MasterTrans
 *
 * @brief  ʹFIFOͶֽ
 *
 * @param  pbuf:͵׵ַ
 *
 * @return   None
 */
void SPI0_MasterTrans( UINT8 *pbuf, UINT16 len )
{
    UINT16 sendlen;

    sendlen = len;
    R8_SPI0_CTRL_MOD &= ~RB_SPI_FIFO_DIR;        //ݷΪ
    R16_SPI0_TOTAL_CNT = sendlen;                //Ҫ͵ݳ
    R8_SPI0_INT_FLAG = RB_SPI_IF_CNT_END;
    while( sendlen )
    {
        if( R8_SPI0_FIFO_COUNT < SPI_FIFO_SIZE )
        {
            R8_SPI0_FIFO = *pbuf;
            pbuf++;
            sendlen--;
        }
    }
    while( R8_SPI0_FIFO_COUNT != 0 );             //ȴFIFOеȫ
}

/*******************************************************************************
 * @fn     SPI0_MasterRecv
 *
 * @brief  ʹFIFOնֽ
 *
 * @param  pbuf: ͵׵ַ
 *
 * @return   None
 **/
void SPI0_MasterRecv( UINT8 *pbuf, UINT16 len )
{
    UINT16  readlen;

    readlen = len;
    R8_SPI0_CTRL_MOD |= RB_SPI_FIFO_DIR;          //ݷΪ
    R16_SPI0_TOTAL_CNT = len;                     //ҪյݳȣFIFOΪ볤ȲΪ0
    R8_SPI0_INT_FLAG = RB_SPI_IF_CNT_END;
    while( readlen )
    {
        if( R8_SPI0_FIFO_COUNT )
        {
            *pbuf = R8_SPI0_FIFO;
            pbuf++;
            readlen--;
        }
    }
}

/*******************************************************************************
 * @fn     SPI0_MasterDMATrans
 *
 * @brief  DMAʽ
 *
 * @param  pbuf: ʼַ
 *
 * @return   None
 */
void SPI0_MasterDMATrans( PUINT8 pbuf, UINT16 len)
{
    R8_SPI0_CTRL_MOD &= ~RB_SPI_FIFO_DIR;
    R32_SPI0_DMA_BEG = (UINT32)pbuf;
    R32_SPI0_DMA_END = (UINT32)(pbuf + len);
    R16_SPI0_TOTAL_CNT = len;
    R8_SPI0_INT_FLAG = RB_SPI_IF_CNT_END|RB_SPI_IF_DMA_END;
    R8_SPI0_CTRL_CFG |= RB_SPI_DMA_ENABLE;
    while(!(R8_SPI0_INT_FLAG & RB_SPI_IF_CNT_END));
    R8_SPI0_CTRL_CFG &= ~RB_SPI_DMA_ENABLE;
}

/*******************************************************************************
 * @fn     SPI0_MasterDMARecv
 *
 * @brief  DMAʽ
 *
 * @param  pbuf: ݴʼַ
 *
 * @return   None
 **/
void SPI0_MasterDMARecv( PUINT8 pbuf, UINT16 len)
{
    R8_SPI0_CTRL_MOD |= RB_SPI_FIFO_DIR;
    R32_SPI0_DMA_BEG = (UINT32)pbuf;
    R32_SPI0_DMA_END = (UINT32)(pbuf + len);
    R16_SPI0_TOTAL_CNT = len;
    R8_SPI0_INT_FLAG = RB_SPI_IF_CNT_END|RB_SPI_IF_DMA_END;
    R8_SPI0_CTRL_CFG |= RB_SPI_DMA_ENABLE;
    while(!(R8_SPI0_INT_FLAG & RB_SPI_IF_CNT_END));
    R8_SPI0_CTRL_CFG &= ~RB_SPI_DMA_ENABLE;
}

/*******************************************************************************
 * @fn     SPI0_SlaveInit
 *
 * @brief  豸ģʽĬϳʼ
 * 
 * @return   None
 */
void SPI0_SlaveInit( void )
{
    R8_SPI0_CTRL_MOD = RB_SPI_ALL_CLEAR;             //FIFO//жϱ־Ĵ0д1ǿջ
    R8_SPI0_CTRL_MOD = RB_SPI_MISO_OE | RB_SPI_MODE_SLAVE;
    R8_SPI0_CTRL_CFG |= RB_SPI_AUTO_IF;              //ʹܷBUFFER/FIFOԶ־λ
}

/*******************************************************************************
 * @fn     SPI0_SlaveRecvByte
 *
 * @brief  ӻģʽһֽ
 * 
 * @return   յ
 */
UINT8 SPI0_SlaveRecvByte( void )
{
    R8_SPI0_CTRL_MOD |= RB_SPI_FIFO_DIR;              //Ϊģʽ
    while( R8_SPI0_FIFO_COUNT == 0 );
    return R8_SPI0_FIFO;
}

/*******************************************************************************
 * @fn     SPI0_SlaveRecvByte
 *
 * @brief  ӻģʽһֽ
 * 
 * @return   յ
 **/
void SPI0_SlaveSendByte( UINT8 d )
{
    R8_SPI0_CTRL_MOD &= ~RB_SPI_FIFO_DIR;              //ݷΪ
    R8_SPI0_FIFO = d;
    while( R8_SPI0_FIFO_COUNT != 0 );                  //ȴ
}

/*******************************************************************************
 * @fn     SPI0_SlaveRecv
 *
 * @brief  ӻģʽնֽ
 *
 * @param  pbuf: ݴʼַ
 *
 * @return   None
 **/
void SPI0_SlaveRecv( PUINT8 pbuf, UINT16 len )
{
    UINT16 revlen;

    revlen = len;
    R8_SPI0_CTRL_MOD |= RB_SPI_FIFO_DIR;                //Ϊģʽ
    R16_SPI0_TOTAL_CNT = revlen;                        //SPIշܳȼĴиֵ
    R8_SPI0_INT_FLAG = RB_SPI_IF_CNT_END;               //SPIжϱ־Ĵ  ȫֽڴɱ־д10
    while( revlen )
    {
        if( R8_SPI0_FIFO_COUNT )                        //ǰFIFOֽڼ
        {
            *pbuf = R8_SPI0_FIFO;
            pbuf++;
            revlen--;
        }
    }
}

/*******************************************************************************
 * @fn     SPI0_SlaveTrans
 *
 * @brief  ӻģʽͶֽ
 *
 * @param  pbuf: ͵׵ַ
 *
 * @return   None
 */
void SPI0_SlaveTrans( UINT8 *pbuf, UINT16 len )
{
    UINT16 sendlen;

    sendlen = len;
    R8_SPI0_CTRL_MOD &= ~RB_SPI_FIFO_DIR;              //ݷΪ
    R16_SPI0_TOTAL_CNT = sendlen;                      //Ҫ͵ݳ
    R8_SPI0_INT_FLAG = RB_SPI_IF_CNT_END;              //SPIжϱ־Ĵ  ȫֽڴɱ־д10
    while( sendlen )
    {
        if( R8_SPI0_FIFO_COUNT < SPI_FIFO_SIZE )       //ȽϵǰFIFOֽڼС
        {
            R8_SPI0_FIFO = *pbuf;
            pbuf++;
            sendlen--;
        }
    }
    while( R8_SPI0_FIFO_COUNT != 0 );                  //ȴFIFOеȫ
}


/*******************************************************************************
 * @fn     SPI1_MasterDefInit
 *
 * @brief  ģʽĬϳʼ
 *
 * @return   None
 */
void SPI1_MasterDefInit( void )
{
    R8_SPI1_CLOCK_DIV = 4;                                   //Ƶʱ4Ƶ
    R8_SPI1_CTRL_MOD = RB_SPI_ALL_CLEAR;
    R8_SPI1_CTRL_MOD = RB_SPI_MOSI_OE | RB_SPI_SCK_OE ;
    R8_SPI1_CTRL_CFG |= RB_SPI_AUTO_IF;
    R8_SPI1_CTRL_CFG &= ~RB_SPI_DMA_ENABLE;                  //DMAʽ
    //R8_SPI1_CTRL_CFG |= RB_SPI_DMA_ENABLE;                   //DMAʽ
}

/*******************************************************************************
 * @fn     SPI1_DataMode
 *
 * @brief  ģʽ
 *
 * @param  m: ģʽ
 *
 * @return   None
 ***/
void SPI1_DataMode( ModeBitOrderTypeDef m )
{
    switch( m )
    {
        case Mode0_LowBitINFront:
            R8_SPI1_CTRL_MOD &= ~RB_SPI_MST_SCK_MOD;
            R8_SPI1_CTRL_CFG |= RB_SPI_BIT_ORDER;
            break;
        case Mode0_HighBitINFront:
            R8_SPI1_CTRL_MOD &= ~RB_SPI_MST_SCK_MOD;
            R8_SPI1_CTRL_CFG &= ~RB_SPI_BIT_ORDER;
            break;
        case Mode3_LowBitINFront:
            R8_SPI1_CTRL_MOD |= RB_SPI_MST_SCK_MOD;
            R8_SPI1_CTRL_CFG |= RB_SPI_BIT_ORDER;
            break;
        case Mode3_HighBitINFront:
            R8_SPI1_CTRL_MOD |= RB_SPI_MST_SCK_MOD;
            R8_SPI1_CTRL_CFG &= ~RB_SPI_BIT_ORDER;
            break;
        default:
            break;
    }
}

/*******************************************************************************
 * @fn     SPI1_MasterSendByte
 *
 * @brief  ͵ֽ(buffer)
 *
 * @param  d - ֽ
 *
 * @return   None
 */
void SPI1_MasterSendByte( UINT8 d )
{
    R8_SPI1_CTRL_MOD &= ~RB_SPI_FIFO_DIR;
    R8_SPI1_BUFFER = d;
    while( !(R8_SPI1_INT_FLAG & RB_SPI_FREE) );
}

/*******************************************************************************
 * @fn     SPI1_MasterRecvByte
 *
 * @brief  յֽ (buffer)
 *
 * @return   յֽ
 */
UINT8 SPI1_MasterRecvByte( void )
{
    R8_SPI1_CTRL_MOD &= ~RB_SPI_FIFO_DIR;
    R8_SPI1_BUFFER = 0xFF;                     //
    while( !(R8_SPI1_INT_FLAG & RB_SPI_FREE) );
    return ( R8_SPI1_BUFFER );
}

/*******************************************************************************
 * @fn     SPI1_MasterTrans
 *
 * @brief  ʹFIFOͶֽ
 *
 * @param  pbuf - ͵׵ַ
 *         len - ͵ݳȣ4095
 * @return   None
 */
void SPI1_MasterTrans( UINT8 *pbuf, UINT16 len )
{
    UINT16 sendlen;

    sendlen = len;
    R8_SPI1_CTRL_MOD &= ~RB_SPI_FIFO_DIR;        //ݷΪ
    R16_SPI1_TOTAL_CNT = sendlen;                //Ҫ͵ݳ
    R8_SPI1_INT_FLAG = RB_SPI_IF_CNT_END;
    while( sendlen )
    {
        if( R8_SPI1_FIFO_COUNT < SPI_FIFO_SIZE )
        {
            R8_SPI1_FIFO = *pbuf;
            pbuf++;
            sendlen--;
        }
    }
    while( R8_SPI1_FIFO_COUNT != 0 );             //ȴFIFOеȫ
}

/*******************************************************************************
 * @fn     SPI1_MasterRecv
 *
 * @brief  ʹFIFOնֽ
 *
 * @param  pbuf - ͵׵ַ
 *         len - ͵ݳȣ4095
 * @return   None
 **/
void SPI1_MasterRecv( UINT8 *pbuf, UINT16 len )
{
    UINT16  readlen;

    readlen = len;
    R8_SPI1_CTRL_MOD |= RB_SPI_FIFO_DIR;         //ݷΪ
    R16_SPI1_TOTAL_CNT = len;                    //ҪյݳȣFIFOΪ볤ȲΪ0
    R8_SPI1_INT_FLAG = RB_SPI_IF_CNT_END;
    while( readlen )
    {
        if( R8_SPI1_FIFO_COUNT )
        {
            *pbuf = R8_SPI1_FIFO;
            pbuf++;
            readlen--;
        }
    }
}

/*******************************************************************************
 * @fn     SPI1_MasterDMATrans
 *
 * @brief  DMAʽ
 *
 * @param  pbuf - ʼַ
 *         len - ݳ
 * @return   None
 */
void SPI1_MasterDMATrans( PUINT8 pbuf, UINT16 len)
{
    R8_SPI1_CTRL_MOD &= ~RB_SPI_FIFO_DIR;
    R32_SPI1_DMA_BEG = (UINT32)pbuf;
    R32_SPI1_DMA_END = (UINT32)(pbuf + len);
    R16_SPI1_TOTAL_CNT = len;
    R8_SPI1_INT_FLAG = RB_SPI_IF_CNT_END|RB_SPI_IF_DMA_END;
    R8_SPI1_CTRL_CFG |= RB_SPI_DMA_ENABLE;
    while(!(R8_SPI1_INT_FLAG & RB_SPI_IF_CNT_END));
    R8_SPI1_CTRL_CFG &= ~RB_SPI_DMA_ENABLE;
}

/*******************************************************************************
 * @fn     SPI1_MasterDMARecv
 *
 * @brief  DMAʽ
 *
 * @param  pbuf - ݴʼַ
 *         len - ݳ
 *
 * @return   None
 */
void SPI1_MasterDMARecv( PUINT8 pbuf, UINT16 len)
{
    R8_SPI1_CTRL_MOD |= RB_SPI_FIFO_DIR;
    R32_SPI1_DMA_BEG = (UINT32)pbuf;
    R32_SPI1_DMA_END = (UINT32)(pbuf + len);
    R16_SPI1_TOTAL_CNT = len;
    R8_SPI1_INT_FLAG = RB_SPI_IF_CNT_END|RB_SPI_IF_DMA_END;
    R8_SPI1_CTRL_CFG |= RB_SPI_DMA_ENABLE;
    while(!(R8_SPI0_INT_FLAG & RB_SPI_IF_CNT_END));
    R8_SPI1_CTRL_CFG &= ~RB_SPI_DMA_ENABLE;
}

/*******************************************************************************
 * @fn     SPI1_SlaveInit
 *
 * @brief  豸ģʽĬϳʼ
 *
 * @return   None
 */
void SPI1_SlaveInit( void )
{
    R8_SPI1_CTRL_MOD = RB_SPI_ALL_CLEAR;
    R8_SPI1_CTRL_MOD = RB_SPI_MISO_OE | RB_SPI_MODE_SLAVE;
    R8_SPI1_CTRL_CFG |= RB_SPI_AUTO_IF;
}

/*******************************************************************************
 * @fn     SPI1_SlaveRecvByte
 *
 * @brief  ӻģʽһֽ
 * 
 * @return   յ
 */
UINT8 SPI1_SlaveRecvByte( void )
{
    R8_SPI1_CTRL_MOD |= RB_SPI_FIFO_DIR;
    while( R8_SPI1_FIFO_COUNT == 0 );
    return R8_SPI1_FIFO;
}

/*******************************************************************************
 * @fn     SPI1_SlaveRecvByte
 *
 * @brief  ӻģʽһֽ
 * 
 * @return   յ
 */
void SPI1_SlaveSendByte( UINT8 d )
{
    R8_SPI1_CTRL_MOD &= ~RB_SPI_FIFO_DIR;
    R8_SPI1_FIFO = d;
    while( R8_SPI1_FIFO_COUNT != 0 );        //ȴ
}

/*******************************************************************************
 * @fn     SPI1_SlaveRecv
 * @brief  ӻģʽնֽ
 * @param  pbuf - ݴʼַ
 *         len - ݳ
 * @return   None
 */
void SPI1_SlaveRecv( PUINT8 pbuf, UINT16 len )
{
    UINT16 revlen;

    revlen = len;
    R8_SPI1_CTRL_MOD |= RB_SPI_FIFO_DIR;
    R16_SPI1_TOTAL_CNT = revlen;
    R8_SPI1_INT_FLAG = RB_SPI_IF_CNT_END;
    while( revlen )
    {
        if( R8_SPI1_FIFO_COUNT )
        {
            *pbuf = R8_SPI1_FIFO;
            pbuf++;
            revlen--;
        }
    }
}

/*******************************************************************************
 * @fn     SPI1_SlaveTrans
 *
 * @brief  ӻģʽͶֽ
 *
 * @param  pbuf - ͵׵ַ
 *         len - ͵ݳȣ4095
 * @return   None
 */
void SPI1_SlaveTrans( UINT8 *pbuf, UINT16 len )
{
    UINT16 sendlen;

    sendlen = len;
    R8_SPI1_CTRL_MOD &= ~RB_SPI_FIFO_DIR;              //ݷΪ
    R16_SPI1_TOTAL_CNT = sendlen;                      //Ҫ͵ݳ
    R8_SPI1_INT_FLAG = RB_SPI_IF_CNT_END;
    while( sendlen )
    {
        if( R8_SPI1_FIFO_COUNT < SPI_FIFO_SIZE )
        {
            R8_SPI1_FIFO = *pbuf;
            pbuf++;
            sendlen--;
        }
    }
    while( R8_SPI1_FIFO_COUNT != 0 );                   //ȴFIFOеȫ
}







