/********************************** (C) COPYRIGHT *******************************
* File Name          : CH56x_usb30.c
* Author             : WCH
* Version            : V1.1
* Date               : 2020/12/31
* Description        :
* Copyright (c) 2021 Nanjing Qinheng Microelectronics Co., Ltd.
* SPDX-License-Identifier: Apache-2.0
*******************************************************************************/
#include "CH56x_usb30.h"
#include "CH56x_usb20.h"
#include "usb30_desc.h"
#include "UVCLIB.H"

/* Global Variable */
UINT8V      tx_lmp_port = 0;
UINT8V      link_sta = 0;
UINT32      SetupLen = 0;
UINT8       SetupReqCode = 0;
PUINT8      pDescr;
__attribute__ ((aligned(16))) UINT8 endp0buff[512] __attribute__((section(".DMADATA")));    //Endpoint 0 data send / receive buffer
__attribute__ ((aligned(16))) UINT8 endp1RTbuff[1024] __attribute__((section(".DMADATA"))); //Endpoint 1 data send / receive buffer
__attribute__ ((aligned(16))) UINT8 endp2RTbuff[1024] __attribute__((section(".DMADATA"))); //Endpoint 2 data send / receive buffer
__attribute__ ((aligned(16))) UINT8 endp3RTbuff[1024] __attribute__((section(".DMADATA"))); //Endpoint 3 data send / receive buffer
__attribute__ ((aligned(16))) UINT8 endp4RTbuff[1024] __attribute__((section(".DMADATA"))); //Endpoint 4 data send / receive buffer
__attribute__ ((aligned(16))) UINT8 endp5RTbuff[1024] __attribute__((section(".DMADATA"))); //Endpoint 5 data send / receive buffer
__attribute__ ((aligned(16))) UINT8 endp6RTbuff[1024] __attribute__((section(".DMADATA"))); //Endpoint 6 data send / receive buffer
__attribute__ ((aligned(16))) UINT8 endp7RTbuff[1024] __attribute__((section(".DMADATA"))); //Endpoint 7 data send / receive buffer
/*******************************************************************************
 * @fn      USB30_BUS_RESET
 *
 * @brief   USB3.0 bus reset
 *
 * @return  None
 */
void USB30_BUS_RESET()
{
    USB30D_init(DISABLE);
    mDelaymS(20);
    USB30D_init(ENABLE);
}

/*******************************************************************************
 * @fn      USB30D_init
 *
 * @brief   USB3.0 initialization
 *
 * @return   None
 */
void USB30D_init(FunctionalState sta)
{
    UINT16 i, s;
    if(sta)
    {
        s = USB30_Device_Init();
        if(s)
        {
            printf("Init err\n");
            while(1)
                ;
        }
        USBSS->UEP_CFG = EP0_R_EN | EP0_T_EN  | EP1_T_EN ; // set end point rx/tx enable

        USBSS->UEP0_DMA = (UINT32)(UINT8 *)endp0buff;
        USBSS->UEP1_TX_DMA = (UINT32)(UINT8 *)endp1RTbuff;
        USB30_ISO_Setendp(endp_1|endp_in,ENABLE);

    }
    else
    {
        USB30_Switch_Powermode(POWER_MODE_2);
        USBSS->LINK_CFG = PIPE_RESET | LFPS_RX_PD;
        USBSS->LINK_CTRL = GO_DISABLED | POWER_MODE_3;
        USBSS->LINK_INT_CTRL = 0;
        USBSS->USB_CONTROL = USB_FORCE_RST | USB_ALL_CLR;
    }

}
/*******************************************************************************
 * @fn      USBSS_IRQHandler
 *
 * @brief   USB3.0 Interrupt Handler.
 *
 * @return  None
 */
void USBSS_IRQHandler(void)
{
    USB30_IRQHandler();
}
/*******************************************************************************
 * @fn      TMR0_IRQHandler
 *
 * @brief   USB3.0 Connection failure timeout processing
 *
 * @return  None
 */
void TMR0_IRQHandler()
{
    R8_TMR0_INT_FLAG = RB_TMR_IF_CYC_END;
    PRINT("TMR0_IRQHandler\n");
    if(link_sta == 1)
    {
        link_sta = 0;
        PFIC_DisableIRQ(USBSS_IRQn);
        PFIC_DisableIRQ(LINK_IRQn);
        USB30D_init(DISABLE);
        PRINT("USB3.0 disable\n");
        return;
    }
    if(link_sta != 3)
    {
        PFIC_DisableIRQ(USBSS_IRQn);
        PFIC_DisableIRQ(LINK_IRQn);
        USB30D_init(DISABLE);
        R32_USB_CONTROL = 0;
        PFIC_EnableIRQ(USBHS_IRQn);
        USB20_Device_Init(ENABLE);
    }
    link_sta = 1;
    R8_TMR0_INTER_EN = 0;
    PFIC_DisableIRQ(TMR0_IRQn);
    R8_TMR0_CTRL_MOD = RB_TMR_ALL_CLEAR;
}

/*******************************************************************************
 * @fn      LINK_IRQHandler
 *
 * @brief   USB3.0 Link Interrupt Handler.
 *
 * @return  None
 */
void LINK_IRQHandler()
{
    /*device enter U2*/
    if(USBSS->LINK_INT_FLAG & LINK_Ux_EXIT_FLAG)
    {
        USBSS->LINK_CFG = CFG_EQ_EN | DEEMPH_CFG | TERM_EN;
        USB30_Switch_Powermode(POWER_MODE_0);
        USBSS->LINK_INT_FLAG = LINK_Ux_EXIT_FLAG;
        PRINT("BACK TO U0 !\n\n");
    }
    /*POLLING SHAKE DONE*/
    if(USBSS->LINK_INT_FLAG & LINK_RDY_FLAG)
    {
        USBSS->LINK_INT_FLAG = LINK_RDY_FLAG;
        if(tx_lmp_port) // LMP, TX PORT_CAP & RX PORT_CAP
        {
            USBSS->LMP_TX_DATA0 = LINK_SPEED | PORT_CAP | LMP_HP;
            USBSS->LMP_TX_DATA1 = UP_STREAM | NUM_HP_BUF;
            USBSS->LMP_TX_DATA2 = 0x0;
            tx_lmp_port = 0;
        }
        /*Successful USB3.0 communication*/
        link_sta = 3;
        PFIC_DisableIRQ(TMR0_IRQn);
        R8_TMR0_CTRL_MOD = RB_TMR_ALL_CLEAR;
        R8_TMR0_INTER_EN = 0;
        PFIC_DisableIRQ(USBHS_IRQn);
        USB20_Device_Init(DISABLE);
    }

    if(USBSS->LINK_INT_FLAG & LINK_INACT_FLAG)
    {
        USBSS->LINK_INT_FLAG = LINK_INACT_FLAG;
        USB30_Switch_Powermode(POWER_MODE_2);
    }
    /*GO DISABLED*/
    if(USBSS->LINK_INT_FLAG & LINK_DISABLE_FLAG)
    {
        USBSS->LINK_INT_FLAG = LINK_DISABLE_FLAG;
        link_sta = 1;
        USB30D_init(DISABLE);
        PFIC_DisableIRQ(USBSS_IRQn);
        R8_TMR0_CTRL_MOD = RB_TMR_ALL_CLEAR;
        R8_TMR0_INTER_EN = 0;
        PFIC_DisableIRQ(TMR0_IRQn);
        PFIC_EnableIRQ(USBHS_IRQn);
        USB20_Device_Init(ENABLE);
    }
    if(USBSS->LINK_INT_FLAG & LINK_RX_DET_FLAG)
    {
        USBSS->LINK_INT_FLAG = LINK_RX_DET_FLAG;
        USB30_Switch_Powermode(POWER_MODE_2);
    }
    /*term present , begin POLLING*/
    if(USBSS->LINK_INT_FLAG & TERM_PRESENT_FLAG)
    {
        USBSS->LINK_INT_FLAG = TERM_PRESENT_FLAG;
        if(USBSS->LINK_STATUS & LINK_PRESENT)
        {
            USB30_Switch_Powermode(POWER_MODE_0);
            USBSS->LINK_CTRL |= POLLING_EN;
        }
        else
        {
            USBSS->LINK_INT_CTRL = 0;
            mDelayuS(2000);
            USB30_BUS_RESET();
        }
    }
    /*POLLING SHAKE DONE*/
    if(USBSS->LINK_INT_FLAG & LINK_TXEQ_FLAG)
    {
        tx_lmp_port = 1;
        USBSS->LINK_INT_FLAG = LINK_TXEQ_FLAG;
        USB30_Switch_Powermode(POWER_MODE_0);
    }
    if(USBSS->LINK_INT_FLAG & WARM_RESET_FLAG)
    {
        USBSS->LINK_INT_FLAG = WARM_RESET_FLAG;
        USB30_Switch_Powermode(POWER_MODE_2);
        USB30_BUS_RESET();
        USB30_Device_Setaddress(0);
        USBSS->LINK_CTRL |= TX_WARM_RESET;
        while(USBSS->LINK_STATUS & RX_WARM_RESET)
            ;
        USBSS->LINK_CTRL &= ~TX_WARM_RESET;
        mDelayuS(2);
    }
    /*The host may send hot reset,Note the configuration of the endpoint*/
    if(USBSS->LINK_INT_FLAG & HOT_RESET_FLAG)
    {
        USBSS->USB_CONTROL |= 1 << 31;
        USBSS->LINK_INT_FLAG = HOT_RESET_FLAG; // HOT RESET begin
        USB30_IN_ClearIT(0);
        USB30_IN_Set(ENDP_1, DISABLE, NRDY, 0, 0);
        USB30_IN_Set(ENDP_3, DISABLE, NRDY, 0, 0);

        USB30_Device_Setaddress(0);
        USBSS->LINK_CTRL &= ~TX_HOT_RESET; // HOT RESET end
    }
    /*device enter U1*/
    if(USBSS->LINK_INT_FLAG & LINK_GO_U1_FLAG)
    {
        USB30_Switch_Powermode(POWER_MODE_1);
        USBSS->LINK_INT_FLAG = LINK_GO_U1_FLAG;
    }
    /*device enter U2*/
    if(USBSS->LINK_INT_FLAG & LINK_GO_U2_FLAG)
    {
        USB30_Switch_Powermode(POWER_MODE_2);
        USBSS->LINK_INT_FLAG = LINK_GO_U2_FLAG;
    }
    /*device enter U1*/
    if(USBSS->LINK_INT_FLAG & LINK_GO_U3_FLAG)
    {
        USB30_Switch_Powermode(POWER_MODE_2);
        USBSS->LINK_INT_FLAG = LINK_GO_U3_FLAG;
    }

}

/*******************************************************************************
 * @fn      USB30_NonStandardReq
 *
 * @brief   USB3.0 Nonstandard request processing function
 *
 * @return  Length
 */
UINT16 USB30_NonStandardReq()
{
    SetupReqCode = UsbSetupBuf->bRequest;
    SetupLen = UsbSetupBuf->wLength;
    UINT16 len = 0xFFFF;
    /*Upload data*/
    if(UsbSetupBuf->bRequestType & 0x80){
        len = Res_NonStandardReq(&pDescr);
        if(len != 0xFFFF){
                    len = SetupLen >= ENDP0_MAXPACK ? ENDP0_MAXPACK : SetupLen;
                    memcpy(endp0buff, pDescr,len );
                    SetupLen -= len;
                    pDescr += len;
                }
    }else{
        /*set cur*/
        if(UsbSetupBuf->bRequestType==0x21 && UsbSetupBuf->bRequest == 0x01){
            len = 0;
        }
    }
    return len;

}
/*******************************************************************************
 * @fn      USB30_StandardReq
 *
 * @brief   USB3.0 Standard request
 *
 * @return  Length
 */
UINT16 USB30_StandardReq()
{
    SetupReqCode = UsbSetupBuf->bRequest;
    SetupLen = UsbSetupBuf->wLength;
    UINT16 len = 0;
#if 0
    printf("S:%02x %02x %02x %02x %02x %02x %02x %02x\n", endp0buff[0], endp0buff[1],
            endp0buff[2], endp0buff[3], endp0buff[4], endp0buff[5],
            endp0buff[6], endp0buff[7]);
#endif
    if((UsbSetupBuf->bRequestType & USB_REQ_TYP_MASK ) != USB_REQ_TYP_STANDARD)
    {
        len = USB30_NonStandardReq();
    }
    else
    {
        switch(SetupReqCode)
        {
            case USB_GET_DESCRIPTOR:
                switch(UsbSetupBuf->wValue.bw.bb0)
                {
                        case USB_DESCR_TYP_DEVICE:
                                if(SetupLen>SIZE_DEVICE_DESC) SetupLen  = SIZE_DEVICE_DESC;
                                pDescr = (PUINT8)DeviceDescriptor;
                                break;
                        case USB_DESCR_TYP_CONFIG:
                                if(SetupLen > SIZE_CONFIG_DESC) SetupLen = SIZE_CONFIG_DESC;
                                pDescr = (PUINT8)ConfigDescriptor;
                                break;
                        case USB_DESCR_TYP_BOS:
                                if(SetupLen > SIZE_BOS_DESC) SetupLen = SIZE_BOS_DESC;
                                pDescr = (PUINT8)BOSDescriptor;
                                break;
                        case    USB_DESCR_TYP_STRING:
                                switch(UsbSetupBuf->wValue.bw.bb1)
                                {
                                    case USB_DESCR_LANGID_STRING:
                                        if(SetupLen > SIZE_STRING_LANGID) SetupLen = SIZE_STRING_LANGID;
                                        pDescr = (PUINT8)StringLangID;
                                        break;
                                    case USB_DESCR_VENDOR_STRING:
                                        if(SetupLen > SIZE_STRING_VENDOR) SetupLen = SIZE_STRING_VENDOR;
                                        pDescr = (PUINT8)StringVendor;
                                        break;
                                    case USB_DESCR_PRODUCT_STRING:
                                        if(SetupLen > SIZE_STRING_PRODUCT) SetupLen = SIZE_STRING_PRODUCT;
                                        pDescr = (PUINT8)StringProduct;
                                        break;
                                    case USB_DESCR_SERIAL_STRING:
                                        if(SetupLen > SIZE_STRING_SERIAL) SetupLen = SIZE_STRING_SERIAL;
                                        pDescr = (PUINT8)StringSerial;
                                        break;
                                    case USB_DESCR_OS_STRING:
                                        if(SetupLen >SIZE_STRING_OS) SetupLen = SIZE_STRING_OS;
                                        pDescr = (PUINT8)OSStringDescriptor;
                                        break;
                                    default:
                                        len = USB_DESCR_UNSUPPORTED;
                                        SetupReqCode = INVALID_REQ_CODE;
                                        break;
                                }
                                break;
                        default:
                            len = USB_DESCR_UNSUPPORTED;
                            SetupReqCode = INVALID_REQ_CODE;
                            break;
                }
                if(len != USB_DESCR_UNSUPPORTED){
                    len = SetupLen >= ENDP0_MAXPACK ? ENDP0_MAXPACK : SetupLen;
                    memcpy(endp0buff, pDescr,len );
                    SetupLen -= len;
                    pDescr += len;
                }
                break;
            case USB_SET_ADDRESS:
                        SetupLen = UsbSetupBuf->wValue.bw.bb1;
                        break;
            case 0x31:
                        SetupLen = UsbSetupBuf->wValue.w;
                        break;
            case 0x30:
                        break;
            case USB_SET_CONFIGURATION:
                        break;
            case USB_GET_STATUS:
                        len=2;
                        endp0buff[0]=0x00;
                        endp0buff[1]=0x00;
                        SetupLen = 0;
                        break;
            case USB_CLEAR_FEATURE:
                        break;
            case USB_SET_FEATURE:
                        break;
            case USB_SET_INTERFACE:
                        CtrlCamera();
                        break;
            default:
                    len =USB_DESCR_UNSUPPORTED;
                    SetupReqCode = INVALID_REQ_CODE;
                    printf(" stall \n");
                        break;
        }
    }
    return len;
}

/*******************************************************************************
 * @fn      EP0_IN_Callback
 *
 * @brief   USB3.0 Endpoint 0 IN transaction callback
 *
 * @return  Send length
 */
UINT16 EP0_IN_Callback(void)
{

    UINT16 len = 0;
    switch(SetupReqCode)
    {
        case USB_GET_DESCRIPTOR:
             len = SetupLen >= ENDP0_MAXPACK ? ENDP0_MAXPACK : SetupLen;
             memcpy(  endp0buff, pDescr,len );
             SetupLen -= len;
             pDescr += len;
             break;
    }
    return len;
}

/*******************************************************************************
 * @fn      EP0_OUT_Callback
 *
 * @brief   USB3.0 Endpoint 0 OUT transaction callback
 *
 * @return  None
 */
UINT16 EP0_OUT_Callback()
{
    UINT16 rx_len = 0;
    static UINT8 format = 0;
    static UINT8 frame = 0;
    USB30_OUT_Status( ENDP_0,NULL, &rx_len, NULL );

    /* Switch video format or resolution */
    if(rx_len == 0x1A)
    {
        if( (format != *(UINT8 *)(endp0buff+2)) || (frame != *(UINT8 *)(endp0buff+3))){
            memcpy((UINT8 *)get_cur,(UINT8 *)get_cur_u30,26);
            format = *(UINT8 *)(endp0buff+2);
            frame = *(UINT8 *)(endp0buff+3);
            get_cur[2] = format;
            get_cur[3] = frame;
            Formatchange_flag = *(UINT8 *)(endp0buff+2);
            OV2640_Change_Resolution(frame);
            if(format == 1)
            {
                PFIC_EnableIRQ(DVP_IRQn);
            }
            else
            {
                PFIC_DisableIRQ(DVP_IRQn);
            }
        }
    }

    return 0;
}

/*******************************************************************************
 * @fn      USB30_Setup_Status
 *
 * @brief   USB3.0 Control transfer status stage callback
 *
 * @return  None
 */
void USB30_Setup_Status( void)
{
    switch(SetupReqCode)
    {
        case USB_SET_ADDRESS:
            USB30_Device_Setaddress(SetupLen );
             break;
        case 0x81:
            ClearError();
            break;
        case 0x31:
            USB30_ISO_Setdelay(SetupLen);
            break;
    }
}

/*******************************************************************************
 * @fn      USB30_ITP_Callback
 *
 * @brief   USB3.0 ITP callback function
 *
 * @return  None
 */
void USB30_ITP_Callback(UINT32 ITPCounter)
{
    Endp1_ITPHander();
}

/***************Endpointn IN Transaction Processing*******************/
void EP1_IN_Callback()
{
    Endp1_Hander();
}

void EP2_IN_Callback()
{

}

void EP3_IN_Callback()
{

}
void EP4_IN_Callback()
{
}
void EP5_IN_Callback()
{

}
void EP6_IN_Callback()
{

}
void EP7_IN_Callback()
{

}

/***************Endpointn OUT Transaction Processing*******************/
void EP1_OUT_Callback()
{

}

void EP2_OUT_Callback()
{

}
void EP3_OUT_Callback()
{

}
void EP4_OUT_Callback()
{

}
void EP5_OUT_Callback()
{

}
void EP6_OUT_Callback()
{

}
void EP7_OUT_Callback()
{

}



