/********************************** (C) COPYRIGHT *******************************
* File Name          : usb30_desc.c
* Author             : WCH
* Version            : V1.0
* Date               : 2020/07/31
* Description 		 : 
* Copyright (c) 2021 Nanjing Qinheng Microelectronics Co., Ltd.
* SPDX-License-Identifier: Apache-2.0
*******************************************************************************/
#include "usb30_desc.h"

/* Device Descriptor */
const UINT8 DeviceDescriptor[] =
{
	0x12,
	0x01,
	0x00,
	0x03,//bcdUSB
	0xef,
	0x02,
	0x01,//Device Class
	0x09,//Max packet 512
	0x86,
	0x1A, //VID
	0x04,
	0x23,//PID
	0x01,
	0x00,//bcdDevice
	0x03,//iManufacturer
	0x01,//iProduct
	0x02,//iSerialNumber
	0x01,//bNumConfigurations
};

/* Configuration Descriptor */
const UINT8 ConfigDescriptor[] =
{

        0x09,
        0x02,
        (SIZE_CONFIG_DESC&0xff),
        (SIZE_CONFIG_DESC>>8),
        0x02,
        0x01,
        0x00,
        0xa0,
        0x4b,
        /* Interface Association Descriptor */
        0x08,
        0x0b,
        0x00,
        0x02,
        0x0e,
        0x03,
        0x00,
        0x08,

        /* Standard VC Interface Descriptor */
        0x09,
        0x04,
        0x00,
        0x00,
        0x00,
        0x0e,
        0x01,
        0x00,
        0x08,
        /* Class-specific VC Interface Descriptor */
        0x0d,
        0x24,
        0x01,
        0x00,
        0x01,
        0x4d,
        0x00,
        0x00,
        0x0e,
        0x27,
        0x07,
        0x01,
        0x01,
        /* Input Terminal Descriptor (Composite) */
        0x12,
        0x24,
        0x02,
        0x01,
        0x01,
        0x02,
        0x00,
        0x00,
        0x00,
        0x00,
        0x00,
        0x00,
        0x00,
        0x00,
        0x03,
        0x00,
        0x00,
        0x00,

        0x0b,
        0x24,
        0x05,
        0x03,
        0x01,
        0x00,
        0x00,
        0x02,
        0x00,
        0x00,
        0x00,
        /* Output Terminal Descriptor */
        0x09,
        0x24,
        0x03,
        0x02,
        0x01,
        0x01,
        0x00,
        0x04,
        0x00,
        /* Extension Unit Descriptor */
        0x1a,
        0x24,
        0x06,
        0x04,
        0x5b,
        0x12,
        0x6d,
        0xc6,
        0x80,
        0x04,
        0x44,
        0x08,
        0x8c,
        0x26,
        0xb8,
        0x36,
        0x3a,
        0x84,
        0xde,
        0x63,
        0x03,
        0x01,
        0x03,
        0x01,
        0x07,
        0x00,
        /* Standard VS Interface Descriptor */
        0x09,
        0x04,
        0x01,
        0x00,
        0x00,
        0x0e,
        0x02,
        0x00,
        0x00,
        /* VS Interface Input Header Descriptor */
        0x0e,
        0x24,
        0x01,
        0x01,
        0x6c,    //l
        0x01,    //h
        0x81,
        0x00,
        0x02,
        0x00,
        0x00,
        0x00,
        0x01,
        0x00,

        /* Class-specific VS Format Descriptor--- VS_FORMAT_MJPEG */
        0x0b,                                                                       /* bLength */
        0x24,                                                                       /* bDescriptorTypeCS_INTERFACE */
        0x06,                                                                       /* bDescriptorSubtype VS_FORMAT_MJPEG */
        0x01,                                                                       /* bFormatIndexFirst (and only) format descriptor  */
        0x05,                                                                       /* bNumFrameDescriptors12 frame descriptor for this format follows */
        0x01,                                                                       /* bmFlagsUses fixed size samples */
        0x01,                                                                       /* bDefaultFrameIndexDefault frame index is 1. */
        0x00,                                                                       /* bAspectRatioX */
        0x00,                                                                       /* bAspectRatioY */
        0x00,                                                                       /* bmInterlaceFlags */
        0x00,                                                                       /* bCopyProtect */

        /* 800*600@30fps */
        0x1e,                                                                       /* bLength: 10+(4*n)-4+m */
        0x24,                                                                       /* bDescriptorType: CS_INTERFACE descriptor type */
        0x07,                                                                       /* bDescriptorSubtype: VS_FRAME_MJPEG */
        0x01,                                                                       /* bFrameIndex: First (and only) frame descriptor */
        0x00,                                                                       /* bmCapabilities */
        0x20,0x03,                                                                  /* Width of frame800 */
        0x58,0x02,                                                                  /* Height of frame 600 */
        0x00,0xA0,0xBB,0x0D,                                                        /* Min bit rate in bits/s */
        0x00,0xA0,0xBB,0x0D,                                                        /* Max bit rate in bits/s 800*600*2*30fps * 8*/
        0x00,0xA6,0x0E,0x00,                                                        /* Maximum video or still frame size, in bytes 800*600*2  */
        0x15,0x16,0x05,0x00,                                                        /* Default frame interval is 30fps(333333ns) */
        0x01,                                                                       /* bFrameIntervalType: Continuous frame interval */
        0x15,0x16,0x05,0x00,                                                        /* Default frame interval is 30fps(333333ns) */

        /* 320*240@30fps */
        0x1e,
        0x24,
        0x07,
        0x02,
        0x00,
        0x40,0x01,
        0xf0,0x00,
        0x00,0x80,0x32,0x02,
        0x00,0x80,0x32,0x02,
        0x00,0x58,0x02,0x00,
        0x15,0x16,0x05,0x00,
        0x01,
        0x15,0x16,0x05,0x00,

        /* 640*480@30fps */
        0x1e,
        0x24,
        0x07,
        0x03,
        0x00,
        0x80,0x02,
        0xe0,0x01,
        0x00,0x00,0xca,0x08,
        0x00,0x00,0xca,0x08,
        0x00,0x60,0x09,0x00,
        0x15,0x16,0x05,0x00,
        0x01,
        0x15,0x16,0x05,0x00,

        /* 1280*720@30fps */
        0x1e,
        0x24,
        0x07,
        0x04,
        0x00,
        0x00,0x05,
        0xd0,0x02,
        0x00,0x00,0x5e,0x1a,
        0x00,0x00,0x5e,0x1a,
        0x00,0x20,0x1c,0x00,
        0x15,0x16,0x05,0x00,
        0x01,
        0x15,0x16,0x05,0x00,

        /* 1600*1200@30fps */
        0x1e,
        0x24,
        0x07,
        0x05,
        0x00,
        0x40,0x06,
        0xb0,0x04,
        0x00,0x80,0xee,0x36,
        0x00,0x80,0xee,0x36,
        0x00,0x98,0x3a,0x00,
        0x15,0x16,0x05,0x00,
        0x01,
        0x15,0x16,0x05,0x00,


        /* Color Matching Descriptor */
        0x06,
        0x24,
        0x0d,
        0x01,
        0x01,
        0x04,

        /* Class-specific VS Format Descriptor----VS_FORMAT_UNCOMPRESSED */
        0x1b,
        0x24,
        0x04,
        0x02,
        0x05,
        0x59,
        0x55,
        0x59,
        0x32,
        0x00,
        0x00,
        0x10,
        0x00,
        0x80,
        0x00,
        0x00,
        0xaa,
        0x00,
        0x38,
        0x9b,
        0x71,
        0x10,
        0x01,
        0x00,
        0x00,
        0x00,
        0x00,

        /* Class-specific VS Frame Descriptor*/
        /* 800*600@30fps */
        0x1e,                                                                       /* bLength: 10+(4*n)-4+m */
        0x24,                                                                       /* bDescriptorType: CS_INTERFACE descriptor type */
        0x05,                                                                       /* bDescriptorSubtype: VS_FRAME_MJPEG */
        0x01,                                                                       /* bFrameIndex: First (and only) frame descriptor */
        0x00,                                                                       /* bmCapabilities */
        0x20,0x03,                                                                  /* Width of frame800 */
        0x58,0x02,                                                                  /* Height of frame 600 */
        0x00,0xA0,0xBB,0x0D,                                                        /* Min bit rate in bits/s */
        0x00,0xA0,0xBB,0x0D,                                                        /* Max bit rate in bits/s 800*600*2*30fps * 8*/
        0x00,0xA6,0x0E,0x00,                                                        /* Maximum video or still frame size, in bytes 800*600*2  */
        0x15,0x16,0x05,0x00,                                                        /* Default frame interval is 30fps(333333ns) */
        0x01,                                                                       /* bFrameIntervalType: Continuous frame interval */
        0x15,0x16,0x05,0x00,                                                        /* Default frame interval is 30fps(333333ns) */


        /* 320*240@30fps */
        0x1e,
        0x24,
        0x05,
        0x02,
        0x00,
        0x40,0x01,
        0xf0,0x00,
        0x00,0x80,0x32,0x02,
        0x00,0x80,0x32,0x02,
        0x00,0x58,0x02,0x00,
        0x15,0x16,0x05,0x00,
        0x01,
        0x15,0x16,0x05,0x00,

        /* 640*480@30fps */
        0x1e,
        0x24,
        0x05,
        0x03,
        0x00,
        0x80,0x02,
        0xe0,0x01,
        0x00,0x00,0xca,0x08,
        0x00,0x00,0xca,0x08,
        0x00,0x60,0x09,0x00,
        0x15,0x16,0x05,0x00,
        0x01,
        0x15,0x16,0x05,0x00,

        /* 1280*720@30fps */
        0x1e,
        0x24,
        0x05,
        0x04,
        0x00,
        0x00,0x05,
        0xd0,0x02,
        0x00,0x00,0x5e,0x1a,
        0x00,0x00,0x5e,0x1a,
        0x00,0x20,0x1c,0x00,
        0x15,0x16,0x05,0x00,
        0x01,
        0x15,0x16,0x05,0x00,

        /* 1600*1200@30fps */
        0x1e,
        0x24,
        0x05,
        0x05,
        0x00,
        0x40,0x06,
        0xb0,0x04,
        0x00,0x80,0xee,0x36,
        0x00,0x80,0xee,0x36,
        0x00,0x98,0x3a,0x00,
        0x15,0x16,0x05,0x00,
        0x01,
        0x15,0x16,0x05,0x00,


        /* Color Matching Descriptor */
        0x06,
        0x24,
        0x0d,
        0x01,
        0x01,
        0x04,

        0x09,0x04,0x01,0x01,0x01,0x0e,0x02,0x00,0x00,
        0x07,0x05,0x81,0x05,0x00,0x04,0x01,
        0x06,0x30,0x0b,0x00,0x00,0x80,

};

/* Language Descriptor */
const UINT8 StringLangID[SIZE_STRING_LANGID] =
{
   SIZE_STRING_LANGID,	// this descriptor length
	0x03,	            // descriptor type
	0x09,	            // Language ID 0 low byte
	0x04	            // Language ID 0 high byte
};

/* Manufacturer Descriptor */
const UINT8 StringVendor[SIZE_STRING_VENDOR] =
{
	SIZE_STRING_VENDOR,
	0x03,
	'W', 0, 'C', 0, 'H', 0, 'I', 0, 'C', 0, 'r', 0, 'o', 0, 'e', 0,
	'l', 0, 'e', 0, 'c', 0, 't', 0, 'r', 0, 'o', 0, 'n', 0, 'i', 0,
	'c', 0, 's', 0
};

/* Product Descriptor */
const UINT8 StringProduct[SIZE_STRING_PRODUCT] =
{
	SIZE_STRING_PRODUCT,
	0x03,
	'C', 0, 'H', 0, '5', 0, '6', 0, '9', 0, '_', 0,'C', 0, 'a', 0,
	'm', 0, 'e', 0, 'r', 0, 'a', 0
};

/* Serial Descriptor */
UINT8 StringSerial[SIZE_STRING_SERIAL] =
{
	SIZE_STRING_SERIAL,	// length of this descriptor
	0x03,
	'0',
	0x00,
	'1',
	0x00,
	'2',
	0x00,
	'3',
	0x00,
	'4',
	0x00,
	'5',
	0x00,
	'6',
	0x00,
	'7',
	0x00,
	'8',
	0x00,
	'9',
	0x00,
};

const UINT8 OSStringDescriptor[SIZE_STRING_OS] =
{
	SIZE_STRING_OS,	// length of this descriptor
	0x03,
	'M',
	0x00,
	'S',
	0x00,
	'F',
	0x00,
	'T',
	0x00,
	'1',
	0x00,
	'0',
	0x00,
	'0',
	0x00,
	0x01,
	0x00
};

const UINT8 BOSDescriptor[SIZE_BOS_DESC] =
{
	0x05,   // length of this descriptor
	0x0f,   // CONFIGURATION (2)
	0x16,   // total length includes endpoint descriptors (should be 1 more than last address)
	0x00,   // total length high byte
	0x02,   // number of device cap
	0x07,
	0x10,	// DEVICE CAPABILITY type
	0x02,	// USB2.0 EXTENSION
	0x06,
	0x00,
	0x00,
	0x00,
	0x0a,	// length of this descriptor
	0x10,	// DEVICE CAPABILITY type
	0x03,	// superspeed usb device capability
	0x00,	//
	0x0e,	// ss/hs/fs
	0x00,
	0x01,	// the lowest speed is full speed
	0x0a,	// u1 exit latency is 10us
	0xff,	// u1 exit latency is 8us
	0x07
};

const UINT8 MSOS20DescriptorSet[] =
{
    // Microsoft OS 2.0 Descriptor Set Header
    0x0A, 0x00,             // wLength - 10 bytes
    0x00, 0x00,             // MSOS20_SET_HEADER_DESCRIPTOR
	0x00, 0x00, 0x03, 0x06, // dwWindowsVersion  0x06030000 for Windows Blue
    0x48, 0x00,             // wTotalLength  72 bytes
    // Microsoft OS 2.0 Registry Value Feature Descriptor
    0x3E, 0x00,             // wLength - 62 bytes
    0x04, 0x00,             // wDescriptorType  4 for Registry Property
    0x04, 0x00,             // wPropertyDataType - 4 for REG_DWORD
    0x30, 0x00,             // wPropertyNameLength  48 bytes
    0x53, 0x00, 0x65, 0x00, // Property Name - SelectiveSuspendEnabled
    0x6C, 0x00, 0x65, 0x00,
    0x63, 0x00, 0x74, 0x00,
    0x69, 0x00, 0x76, 0x00,
    0x65, 0x00, 0x53, 0x00,
    0x75, 0x00, 0x73, 0x00,
    0x70, 0x00, 0x65, 0x00,
    0x6E, 0x00, 0x64, 0x00,
    0x45, 0x00, 0x6E, 0x00,
    0x61, 0x00, 0x62, 0x00,
    0x6C, 0x00, 0x65, 0x00,
    0x64, 0x00, 0x00, 0x00,
    0x04, 0x00,             // wPropertyDataLength 4 bytes
    0x01, 0x00, 0x00, 0x00  // PropertyData - 0x00000001
};

const UINT8 PropertyHeader[] =
{
	0x8e, 0x00, 0x00, 0x00, 0x00, 01, 05, 00, 01, 00,
	0x84, 0x00, 0x00, 0x00,
	0x01, 0x00, 0x00, 0x00,
	0x28, 0x00,
	0x44, 0x00, 0x65, 0x00, 0x76, 0x00, 0x69, 0x00, 0x63, 0x00, 0x65, 0x00, 0x49, 0x00, 0x6e,
	0x00, 0x74, 0x00, 0x65, 0x00, 0x72, 0x00, 0x66, 0x00, 0x61, 0x00, 0x63, 0x00, 0x65, 0x00, 0x47, 0x00, 0x55, 0x00, 0x49, 0x00, 0x44, 0x00, 0x00, 0x00,

	0x4e, 0x00, 0x00, 0x00, //L"{12345678-1234-1234-1234-123456789ABC"
	0x7b, 0x00, 0x31, 0x00, 0x32, 0x00, 0x33, 0x00, 0x34, 0x00, 0x35, 0x00, 0x36, 0x00, 0x37, 0x00, 0x38, 0x00,
	0x2d, 0x00, 0x31, 0x00, 0x32, 0x00, 0x33, 0x00, 0x34, 0x00,
	0x2d ,0x00, 0x31, 0x00, 0x32, 0x00, 0x33, 0x00, 0x34, 0x00,
	0x2d, 0x00, 0x31, 0x00, 0x32, 0x00, 0x33, 0x00, 0x34, 0x00, 0x2d, 0x00, 0x31, 0x00, 0x32, 0x00, 0x33, 0x00,
	0x34, 0x00, 0x35, 0x00, 0x36, 0x00, 0x37, 0x00, 0x38, 0x00, 0x39, 0x00, 0x41, 0x00, 0x42, 0x00, 0x43, 0x00,
	0x7d, 0x00, 0x00, 0x00
};

const UINT8 CompactId[] =
{
	0x28, 0x00, 0x00, 0x00, 0x00, 0x01, 0x04, 0x00, 0x01, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x01,
	0x57, 0x49, 0x4e, 0x55, 0x53, 0x42, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00
};

UINT8 GetStatus[] =
{
	0x01, 0x00
};
