/********************************** (C) COPYRIGHT *******************************
* File Name          : UVCLIB.h
* Author             : WCH
* Version            : V1.0
* Date               : 2020/07/31
* Description 		 :
* Copyright (c) 2021 Nanjing Qinheng Microelectronics Co., Ltd.
*******************************************************************************/
#ifndef UVCLIB_H_
#define UVCLIB_H_

#include "dvp.h"
#include "CH56x_usb30.h"

/* Global define */
#define FORMAT_MJPEG    1
#define FORMAT_YUV2     2
#define SOURCECLOCK     ((~(SysTick->CNT))&0xffffffff)
#define PACKSIZE_3      (1024*3 - 12 + 1 )
#define PACKSIZE_2      (1024*2 - 12 + 1 )
#define PACKSIZE_1      (1024*1 - 12 + 1 )
#define BURSTMAXSIZE    12

/* Global Variable */
extern __attribute__ ((aligned(16))) UINT8 YUV2_addr[1024 * 16] __attribute__((section(".DMADATA")));
extern UINT8V get_cur_u20[26];
extern UINT8V get_cur_u30[26];
extern UINT8V get_cur[26];
extern UINT8V Formatchange_flag;
extern UINT16V Resolution_width;
extern UINT16V Resolution_height;

/* Function declaration */
void FillYUVdata( void );
UINT16 Res_NonStandardReq(UINT8 **pDescr);
void ClearError();
void CtrlCamera();
void DVP_Hander(void);
void Endp1_ITPHander(void);
void Endp1_Hander(void);
void Endp1_ISOHander_Hs(void);
void Endp1_Hander_Hs(void);
void CtrlCamera_Hs();

#endif /* UVC_UVCLIB_H_ */
