/********************************** (C) COPYRIGHT *******************************
* File Name          : uvc.c
* Author             : WCH
* Version            : V1.0
* Date               : 2022/12/07
* Description        : uvc Library function
* Copyright (c) 2021 Nanjing Qinheng Microelectronics Co., Ltd.
*******************************************************************************/
#include "UVCLIB.H"

/* Global define */
#define NoError         0x00
#define NotReady        0x01
#define WrongState      0x02
#define Power           0x03
#define OutOfRange      0x04
#define InvalidUnit     0x05
#define InvalidControl  0x06
#define InvalidRequest  0x07
#define InvalidValueWithinRange 0x08
#define Unknown         0xFF

/* Global Variable */
__attribute__ ((aligned(16))) UINT8 YUV2_addr[1024 * 16] __attribute__((section(".DMADATA")));

static UINT32V addr_cnt;
static UINT32V start1;
static UINT32V end1;
static UINT32V fcnt;
static UINT32V class=0;
static UINT32V UVC_DVP;
static UINT8V  Totalcnt=0;
static UINT16V packnum;
static UINT8V lastFrame = 0;
static UINT32V UVC_MBuf_PackCount = 0x00;                                              /* UVC Data Microbuffer Packet Count*/
static UINT8V UVC_MFrame_PackCount = 0x00;                                             /* UVC Microframe packet count */
static UINT32V UVC_MFrame_PackTotalNum = 0x00;                                         /* UVC Total number of current micro frames */
static UINT32V UVC_MFrame_LastPackLen = 0x00;                                          /* UVC The packet length at the end of the current microframe */
static UINT32V UVC_MFrame_ValidFlag = 0x00;                                            /* UVC Valid flag of microframe data(0:invalid; 1valid;) */
UINT8V Formatchange_flag = 2;                                                          /* Video format switching    1-mjpeg   2-yuv2 */
UINT16V Resolution_width = 0;
UINT16V Resolution_height = 0;

typedef struct
{
    UINT8 info[1];
    UINT8 len[2];   //Used by the expansion unit
    UINT8 min[10];
    UINT8 max[10];
    UINT8 res[10];
    UINT8 def[10];
    UINT8 cur[10];
    UINT8 set[10];
}Unit_t;

typedef struct __attribute__((packed))
 {
    UINT8 len;
    UINT8 tog;
    UINT32 Frequeny;
    UINT32 Clock;
    UINT16 count;
    UINT32 reallen;
 }Picture;
Picture MJPEG,YUV2;

typedef struct __attribute__((packed))
{
    UINT32 Length[ 2 ];                                           /* UVC Buffer effective data length */
    UINT8  FullFlag[ 2 ];                                         /* UVC Buffer full flag: 0-full 1-not full  */
    UINT8  LoadNum;                                               /* UVC Buffer Load Number*/
    UINT8  DealNum;                                               /* UVC Buffer processing number */
    UINT8  RemainCount;                                           /* UVC Buffer Remaining Count */
}UVC_BUF_INFO;
volatile UVC_BUF_INFO UVC_BufInfo;

UINT8V get_cur_u20[26]=
{
        0x00, 0x00,
        0x01,
        0x01,
        0x0A, 0x8b, 0x02, 0x00,
        0x00, 0x00,
        0x00, 0x00,
        0x00, 0x00,
        0x00, 0x00,
        0x00, 0x00,

        0x00, 0x48, 0x3f, 0x00,
        0x00, 0x00, 0x00, 0x00
};

UINT8V get_cur_u30[26]=
{
        0x00, 0x00,
        0x01,
        0x01,
        0x0A, 0x8b, 0x02, 0x00,
        0x00, 0x00,
        0x00, 0x00,
        0x00, 0x00,
        0x00, 0x00,
        0x00, 0x00,

        0x00, 0x48, 0x3f, 0x00,
        0x00, 0x00, 0x00, 0x00

};

UINT8V get_cur[26]=
{
        0x00, 0x00,
        0x01,
        0x01,
        0x0A, 0x8b, 0x02, 0x00,
        0x00, 0x00,
        0x00, 0x00,
        0x00, 0x00,
        0x00, 0x00,
        0x00, 0x00,

        0x00, 0x48, 0x3f, 0x00,
        0x0C, 0x78, 0x00, 0x00
};

const UINT8 YUV_Totalcount[5]=
{
    120,
    10,
    30,
    120,
    120
};

Unit_t VAICSID[]={//ID=0,send VideoControl Interface Control Selectors
        {
                0,{0},
                {0},{0},{0},{0},{0},{0}
        },//VC _CONTROL_ UNDEFINED
        {
                0,{0x01,0x00},
                {0},{0},{0},{0},{0x10},{0}
        },//VC_VIDEO_POWER_MODE_CONTROL
        {
                0,{0x01,0x00},
                {0},{0},{0},{0},{NoError},{0}
        },//VC_REQUEST_ERROR_CODE_CONTROL
        {}//Reserved


};
Unit_t CameraID[]={//ID 01
        {
                0,{0},
                {0},{0},{0},{0},{0},{0}
        },//CT_CONTROL_UNDEFINED 0
        {
                0x03,{0x01,0x00},
                {0},{0},{0},{0},{0},{0}

        },//CT_SCANNING_MODE_CONTROL 1
        {
                0x03,{0x01,0x00},
                {0},{0},{0},{0},{0x06},{0}
        },//CT_AE_MODE_CONTROL 2
        {
                0x3,{0x01,0x00},
                {0x00},{0x01},{0x01},{0x00},{0},{0}
        },//CT_AE_PRIORITY_CONTROL 3
        {
                0x0f,{0x04,0x00},
                {0x32,0x00,0x00,0x00},{0x10,0x27,0x00,0x00},{0x01,0x00,0x00,0x00},{0xa6,0x00,0x00,0x00},{0},{0}
        },//CT_EXPOSURE_TIME_ABSOLUTE_CONTROL 4
        {
                0x00,{0x00,0x00},
                {0},{0},{0},{0},{0},{0}
        },//CT_EXPOSURE_TIME_RELATIVE_CONTROL 5
        {
                0x0f,{0x02,0x00},
                {0x00,0x00},{0xff,0x03},{0x01,0x00},{0x44,0x00},{0x44,0x00},{0}
        },//CT_FOCUS_ABSOLUTE_CONTROL 6
        {
                0x00,{0x00,0x00},
                {0},{0},{0},{0},{0},{0}
        },//CT_FOCUS_RELATIVE_CONTROL 7
        {
                0,{0x01},
                {0},{0},{0},{0},{0x01},{0}
        },//CT_FOCUS_AUTO_CONTROL 8
        {
                0,{0},
                {0},{0},{0},{0},{0},{0}
        },//CT_IRIS_ABSOLUTE_CONTROL 9
        {
                0,{0},
                {0},{0},{0},{0},{0},{0}
        },//CT_IRIS_RELATIVE_CONTROL a
        {
                0x03,{0x02,0x00},
                {0x00,0x00},{0x03,0x00},{0x01,0x00},{0x00,0x00},{0},{0}
        },//CT_ZOOM_ABSOLUTE_CONTROL b
        {
                0,{0},
                {0},{0},{0},{0},{0},{0}
        },//CT_ZOOM_RELATIVE_CONTROL c
        {
                0x03,{0x08,0x00},
                {0x00, 0x1f, 0xff, 0xff,  0x40, 0x57, 0xff, 0xff },
                {0x00, 0xe1, 0x00, 0x00,  0xc0, 0xa8, 0x00, 0x00},
                {0x10, 0x0e, 0x00, 0x00,  0x10, 0x0e, 0x00, 0x00},{0x00, 0x00, 0x00, 0x00,  0x00, 0x00, 0x00, 0x00},{0},{0}
        },//CT_PANTILT_ABSOLUTE_CONTROL d
        {
                0,{0},
                {0},{0},{0},{0},{0},{0}
        },//CT_PANTILT_RELATIVE_CONTROL e
        {
                0x03,{0x02,0x00},
                {0},{0x03,0x00},{0x01,0x00},{0},{0},{0}
        },//CT_ROLL_ABSOLUTE_CONTROL f
        {
                0x03,{0x02,0x00},
                {0x00, 0x00},{0x03, 0x00},{0x01, 0x00},{0x00, 0x00},{0},{0}
        },//CT_ROLL_RELATIVE_CONTROL
        {
                0,{0},
                {0},{0},{0},{0},{0},{0}
        },//CT_PRIVACY_CONTROL
        {
                0,{0},
                {0},{0},{0},{0},{0},{0}
        },//CT_FOCUS_SIMPLE_CONTROL
        {
                0,{0},
                {0},{0},{0},{0},{0},{0}
        },//CT_WINDOW_CONTROL
        {
                0,{0},
                {0},{0},{0},{0},{0},{0}
        }//CT_REGION_OF_INTEREST_CONTROL
};

Unit_t ProcessID[]={//ID 02
        {
                0,{0x00,0x00},
                {0},{0},{0},{0},{0},{0}
        },//PU_CONTROL_UNDEFINED 0
        {
                0x03,{0x02,0x00},
                {0x00, 0x00},{0x02, 0x00},{0x01, 0x00},{0x00, 0x00},{0},{0}
        },//PU_BACKLIGHT_COMPENSATION_CONTROL 1
        {
                0x03,{0x02,0x00},
                {0xc0, 0xff},{0x40, 0x00 },{0x01, 0x00},{0x00, 0x00},{0},{0}
        },//PU_BRIGHTNESS_CONTROL 2
        {
                0x03,{0x02,0x00},
                {0x00, 0x00},{0x64, 0x00},{0x01, 0x00 },{0x32, 0x00},{0},{0}
        },//PU_CONTRAST_CONTROL 3
        {
                0,{0x00,0x00},
                {0},{0},{0},{0},{0},{0}
        },//PU_GAIN_CONTROL 4
        {
                0x03,{0x01,0x00},
                {0x00},{0x02},{0x01},{0x01},{0x01},{0}
        },//PU_POWER_LINE_FREQUENCY_CONTROL 5
        {
                0x03,{0x02,0x00},
                {0x4c, 0xff},{ 0xb4, 0x00},{0x01, 0x00 },{0x00, 0x00},{0},{0}
        },//PU_HUE_CONTROL 6
        {
                0x03,{0x02,0x00},
                {0x00, 0x00},{0x64, 0x00},{0x01, 0x00},{0x40, 0x00},{0},{0}
        },//PU_SATURATION_CONTROL 7
        {
                0x03,{0x02,0x00},
                {0x00, 0x00},{0x64, 0x00},{0x01, 0x00},{0x32, 0x00},{0},{0}
        },//PU_SHARPNESS_CONTROL 8
        {
                0x03,{0},
                {0x64, 0x00},{0xf4, 0x01},{0x01, 0x00},{0x2c, 0x01},{0},{0}
        },//PU_GAMMA_CONTROL 9
        {
                0x0f,{0x02,0x00},
               {0xf0, 0x0a},{0x64, 0x19},{0x0a, 0x00},{0xf8, 0x11},{0},{0}
        },//PU_WHITE_BALANCE_TEMPERATURE_CONTROL a
        {
                0,{0},
                {0},{0},{0},{0},{0},{0}
        },//PU_WHITE_BALANCE_TEMPERATURE_AUTO_CONTROL
        {
                0,{0},
                {0},{0},{0},{0},{0},{0}
        },//PU_WHITE_BALANCE_COMPONENT_CONTROL
        {
                0,{0},
                {0},{0},{0},{0},{0},{0}
        },//PU_WHITE_BALANCE_COMPONENT_AUTO_CONTROL
        {
                0,{0},
                {0},{0},{0},{0},{0},{0}
        },//PU_DIGITAL_MULTIPLIER_CONTROL
        {
                0,{0},
                {0},{0},{0},{0},{0},{0}
        },//PU_DIGITAL_MULTIPLIER_LIMIT_CONTROL
        {
                0,{0},
                {0},{0},{0},{0},{0},{0}
        },//PU_HUE_AUTO_CONTROL
        {
                0,{0},
                {0},{0},{0},{0},{0},{0}
        },//PU_ANALOG_VIDEO_STANDARD_CONTROL
        {
                0,{0},
                {0},{0},{0},{0},{0},{0}
        },//PU_ANALOG_LOCK_STATUS_CONTROL
        {
                0,{0},
                {0},{0},{0},{0},{0},{0}
        }//PU_CONTRAST_AUTO_CONTROL

};
Unit_t ExtensionID1[]={//ID 04
        {0},{0},{0},{0},{0},{0},{0},{0},{0},{0},
        {
                0x03,{0x08,0x00},
                {0x00, 0x00, 0x00, 0x00,  0x00, 0x00, 0x00, 0x00},
                {0xff, 0xff, 0xff, 0xff,  0xff, 0xff, 0xff, 0xff },
                {0x01, 0x00, 0x00, 0x00,  0x00, 0x00, 0x00, 0x00},{0x00, 0x00, 0x00, 0x00,  0x00, 0x00, 0x00, 0x00},{0},{0}
        },//a
        {
                0x03,{0x08,0x00},
                {0x00, 0x00, 0x00, 0x00,  0x00, 0x00, 0x00, 0x00},
                {0xff, 0xff, 0xff, 0xff,  0xff, 0xff, 0xff, 0xff },
                {0x01, 0x00, 0x00, 0x00,  0x00, 0x00, 0x00, 0x00},{0x00, 0x00, 0x00, 0x00,  0x00, 0x00, 0x00, 0x00},{0},{0}
        }//b
};
Unit_t ExtensionID2[]={//ID 06
        {0},
        {
                0x03,{0x02,0x00},
                {0x00, 0x00},{0xff, 0xff},{0x00, 0x00},{0x01, 0x00},{0},{0}
        },
        {
                0x03,{0x02,0x00},
                {0xfa, 0xff},{0x06, 0x00},{0x40, 0x00},{0x00, 0x00},{0},{0}
        },
        {
                0x01,{0x02,0x00},
                {0x00, 0x00},{0x00, 0x00},{0x00, 0x00},{0x00, 0x00},{0},{0}
        },
        {
                0x03,{0x01,0x00},
                {0x00, 0x00},{0x00, 0x00},{0x00, 0x00},{0x00, 0x00},{0},{0}
        },
        {
                0x03,{0x01,0x00},
               {0x00, 0x00},{0x00, 0x00},{0x00, 0x00},{0x00, 0x00},{0},{0}
        },
        {
                0x03,{0x01,0x00},
                {0x00, 0x00},{0x00, 0x00},{0x00, 0x00},{0x00, 0x00},{0},{0}
        },{0},{0},{0},{0},{0},
        {0},{0},{0},{0},{0},{0},{0},
        {
                0x03,{0x01,0x00},
               {0x00, 0x00},{0x01, 0x00},{0x01, 0x00},{0x00, 0x00},{0},{0}
        },
        {
                0x03,{0x0a,0x00},
                {0},{0x00, 0x00, 0x00, 0x00,  0x00, 0x00, 0x00, 0x00,  0x09, 0x00 },{0},{0},{0},{0}
        },
        {
                0x01,{0x04,0x00},
                {0},{0},{0},{0},{0},{0}
        },
        {
                0x03,{0x01,0x00},
                {0x00, 0x00},{0x01, 0x00},{0x01, 0x00},{0x00, 0x00},{0},{0}
        },
        {
                0x03,{0x01,0x00},
               {0x01, 0x00},{0x03, 0x00},{0x02, 0x00},{0x01, 0x00},{0},{0}
        },
        {
                0x03,{0x01,0x00},
                {0x01, 0x00},{0x00, 0x00},{0x01, 0x00},{0x01, 0x00},{0},{0}
        }
};

/*******************************************************************************
 * @fn      Res_NonStandardReq
 *
 * @brief   Nonstandard request processing function
 *
 * @return  None
 */
void FillYUVdata( void )
{
    UINT16 i;
    for ( i = 0; i < 1024 * 16; i += 4 ) {//yuv data
        YUV2_addr[i] =   0x23;
        YUV2_addr[i+1] = 0xd4;
        YUV2_addr[i+2] = 0x23;
        YUV2_addr[i+3] = 0x72;
    }
}

/*******************************************************************************
 * @fn      Res_NonStandardReq
 *
 * @brief   Nonstandard request processing function
 *
 * @return  Length
 */
UINT16 Res_NonStandardReq(UINT8 **pDescr){
    if(UsbSetupBuf->bRequestType==0xA1){
        switch(UsbSetupBuf->wIndex.bw.bb0){//UsbSetupBuf->wValue.bw.bb0
                    case 00:
                        switch(UsbSetupBuf->wIndex.bw.bb1){
                            case 00://Only send request to the VideoControl interface (interface ID 00)
                                switch(UsbSetupBuf->bRequest){
                                    case 0x81://GET CUR
                                                *pDescr = (PUINT8)&VAICSID[UsbSetupBuf->wValue.bw.bb0].cur;
                                                break;
                                }
                                break;
                            case 01://
                                switch(UsbSetupBuf->bRequest){
                                        case 0x81://GET CUR
                                        case 0x82:
                                        case 0x83:
                                                *pDescr = (PUINT8)&get_cur;
                                                break;
                                }
                                break;
                            }
                        break;
                    case 01:
                        switch(UsbSetupBuf->bRequest){//LEN->INFO->MIN->MAX->RES->DEF
                            case 0x81://GET CUR
                                *pDescr = (PUINT8)&CameraID[UsbSetupBuf->wValue.bw.bb0].cur;
                                break;
                            case 0x82://GET MIN
                                *pDescr = (PUINT8)&CameraID[UsbSetupBuf->wValue.bw.bb0].min;
                                break;
                            case 0x83://GET MAX
                                *pDescr = (PUINT8)&CameraID[UsbSetupBuf->wValue.bw.bb0].max;
                                break;
                            case 0x84://GET RES
                                *pDescr = (PUINT8)&CameraID[UsbSetupBuf->wValue.bw.bb0].res;
                                break;
                            case 0x85://GET LEN
                                *pDescr = (PUINT8)&CameraID[UsbSetupBuf->wValue.bw.bb0].len;
                                break;
                            case 0x86:// GET INFO
                                *pDescr = (PUINT8)&CameraID[UsbSetupBuf->wValue.bw.bb0].info;
                                break;
                            case 0x87://GET DEF
                                *pDescr = (PUINT8)&CameraID[UsbSetupBuf->wValue.bw.bb0].def;
                                break;
                        }
                        break;
                    case 02:
                        switch(UsbSetupBuf->bRequest){//LEN->INFO->MIN->MAX->RES->DEF
                            case 0x81://GET CUR
                                *pDescr = (PUINT8)&ProcessID[UsbSetupBuf->wValue.bw.bb0].cur;
                                break;
                            case 0x82://GET MIN
                                *pDescr = (PUINT8)&ProcessID[UsbSetupBuf->wValue.bw.bb0].min;
                                break;
                            case 0x83://GET MAX
                                *pDescr = (PUINT8)&ProcessID[UsbSetupBuf->wValue.bw.bb0].max;
                                break;
                            case 0x84://GET RES
                                *pDescr = (PUINT8)&ProcessID[UsbSetupBuf->wValue.bw.bb0].res;
                                break;
                            case 0x85://GET LEN
                                *pDescr = (PUINT8)&ProcessID[UsbSetupBuf->wValue.bw.bb0].len;
                                break;
                            case 0x86:// GET INFO
                                *pDescr = (PUINT8)&ProcessID[UsbSetupBuf->wValue.bw.bb0].info;
                                break;
                            case 0x87://GET DEF
                                *pDescr = (PUINT8)&ProcessID[UsbSetupBuf->wValue.bw.bb0].def;
                                break;
                        }
                        break;
                    case 04:
                        switch(UsbSetupBuf->bRequest){//LEN->INFO->MIN->MAX->RES->DEF
                            case 0x81://GET CUR
                                *pDescr = (PUINT8)&ExtensionID1[UsbSetupBuf->wValue.bw.bb0].cur;
                                break;
                            case 0x82://GET MIN
                                *pDescr = (PUINT8)&ExtensionID1[UsbSetupBuf->wValue.bw.bb0].min;
                                break;
                            case 0x83://GET MAX
                                *pDescr = (PUINT8)&ExtensionID1[UsbSetupBuf->wValue.bw.bb0].max;
                                break;
                            case 0x84://GET RES
                                *pDescr = (PUINT8)&ExtensionID1[UsbSetupBuf->wValue.bw.bb0].res;
                                break;
                            case 0x85://GET LEN
                                *pDescr = (PUINT8)&ExtensionID1[UsbSetupBuf->wValue.bw.bb0].len;
                                break;
                            case 0x86:// GET INFO
                                *pDescr = (PUINT8)&ExtensionID1[UsbSetupBuf->wValue.bw.bb0].info;
                                break;
                            case 0x87://GET DEF
                                *pDescr = (PUINT8)&ExtensionID1[UsbSetupBuf->wValue.bw.bb0].def;
                                break;
                        }
                        break;
                    case 06:
                        switch(UsbSetupBuf->bRequest){//LEN->INFO->MIN->MAX->RES->DEF
                            case 0x81://GET CUR
                                *pDescr = (PUINT8)&ExtensionID2[UsbSetupBuf->wValue.bw.bb0].cur;
                                break;
                            case 0x82://GET MIN
                                *pDescr = (PUINT8)&ExtensionID2[UsbSetupBuf->wValue.bw.bb0].min;
                                break;
                            case 0x83://GET MAX
                                *pDescr = (PUINT8)&ExtensionID2[UsbSetupBuf->wValue.bw.bb0].max;
                                break;
                            case 0x84://GET RES
                                *pDescr = (PUINT8)&ExtensionID2[UsbSetupBuf->wValue.bw.bb0].res;
                                break;
                            case 0x85://GET LEN
                                *pDescr = (PUINT8)&ExtensionID2[UsbSetupBuf->wValue.bw.bb0].len;
                                break;
                            case 0x86:// GET INFO
                                *pDescr = (PUINT8)&ExtensionID2[UsbSetupBuf->wValue.bw.bb0].info;
                                break;
                            case 0x87://GET DEF
                                *pDescr = (PUINT8)&ExtensionID2[UsbSetupBuf->wValue.bw.bb0].def;
                                break;
                        }
                        break;
                    }

        if(UsbSetupBuf->wIndex.bw.bb0 ==0x01 &&((UsbSetupBuf->wValue.bw.bb0==0x14) ||(UsbSetupBuf->wValue.bw.bb0==0x09)))
        {
                VAICSID[2].cur[0]=(UINT8)InvalidControl;
                return 0xFFFF;
        }
    }
    return 0;
}

/*******************************************************************************
 * @fn      clearError
 *
 * @brief   clear error
 *
 * @return  None
 */
void ClearError( void )
{
    VAICSID[UsbSetupBuf->wValue.bw.bb0].cur[0]=NoError;
}

/*******************************************************************************
* Function Name  : UVC_SourceClock
* Description    : UVC Source Clock enable/disable
* Input          : sta     enable/disable
* Output         : None
* Return         : None
*******************************************************************************/
void UVC_SourceClock(FunctionalState sta)
{
  if(sta)
  {
   SysTick->CMP=0xffffffff;
   SysTick->CTLR=(1<<8)|(1<<2)|(1<<0);

  }
  else
  {
      /*systick close*/
      SysTick->CTLR=0;
  }
}

/*******************************************************************************
 * @fn      ctrlCamera
 *
 * @brief   USB3.0 set interface processing function
 *
 * @return  None
 */
void CtrlCamera(){
    class = 1;
    if(UsbSetupBuf->wValue.bw.bb1 > 0)
    {
        /* Fill frame header data */
        MJPEG.Clock = 0x0136E5;
        MJPEG.Frequeny = ~((*(UINT32V *)(0xe000f004)));
        MJPEG.count=0x04DD;
        MJPEG.len=0x0c;
        MJPEG.tog = 0x8c;
        MJPEG.reallen=0x0C;

        YUV2.Clock = 0x0;
        YUV2.len=0x0c;
        YUV2.tog = 0x8c;
        YUV2.reallen=0x0C;


        /* Calculate related variables */
        UVC_MFrame_PackTotalNum = 0;
        UVC_MFrame_PackCount = UVC_MFrame_PackTotalNum;
        UVC_MBuf_PackCount = 0x00;
        Totalcnt = 0;

        UVC_DVP = 0x01;
        memcpy(endp1RTbuff,  (uint8_t *)&MJPEG,12 );
        USB30_IN_ClearIT(endp_1);
        USB30_IN_Set(endp_1,ENABLE,ACK_TP,NUMP_1,MJPEG.reallen);

        USB30_ITP_Enable(ENABLE);
    }
    else
    {
        UVC_DVP = 0x00;
        USB30_ITP_Enable(DISABLE);
    }
}
/*******************************************************************************
 * @fn      ctrlCamera_hs
 *
 * @brief   USB2.0 set interface processing function
 *
 * @return  None
 */
void CtrlCamera_Hs(){
    class = 1;
    if( UsbSetupBuf->wValue.bw.bb1 > 0)
    {
        UVC_SourceClock(1);
        MJPEG.Clock = 0;
        MJPEG.Frequeny = ~((*(UINT32V *)(0xe000f004)));
        MJPEG.count = 0;
        MJPEG.len = 0x0c;
        MJPEG.tog = 0x8c;
        MJPEG.reallen=0x0C;

        YUV2.Clock = 0;
        YUV2.len=0x0c;
        YUV2.tog = 0x8c;
        YUV2.reallen=0x0C;

        UVC_DVP = 0x01;
        memcpy(endp1RTbuff,  (uint8_t *)&MJPEG,12 );
        R16_UEP1_T_LEN =  12;
        R8_UEP1_TX_CTRL &= ~(3<<3);
    }
    else
    {
        UVC_DVP = 0x00;
        UVC_SourceClock(0);
    }
}

/*******************************************************************************
 * @fn      endp1_ITPHander
 *
 * @brief   USB3.0 endpoint 1 ITP processing function
 *
 * @return  None
 */
void Endp1_ITPHander(void)
{
    UINT8 seq;
    if(Formatchange_flag == 2){

        UVC_MFrame_PackCount = 0x00;
        UVC_MBuf_PackCount = 0x00;
        UVC_MFrame_ValidFlag = 0x01;
        YUV2.tog &= ~(1<<1);
        if((lastFrame==1))
        {
            YUV2.tog ^= 0x01;
            YUV2.tog &= ~(1<<1);
            lastFrame=0;
        }
        if( UVC_BufInfo.FullFlag[ UVC_BufInfo.DealNum ] == 0x00 )
        {
            UVC_MFrame_PackTotalNum = UVC_BufInfo.Length[ UVC_BufInfo.DealNum ] / 1024;
            UVC_MFrame_LastPackLen =  UVC_BufInfo.Length[ UVC_BufInfo.DealNum ] % 1024;

            if( UVC_MFrame_LastPackLen )
            {
                UVC_MFrame_PackTotalNum++;
            }
            else if( UVC_MFrame_LastPackLen == 0 )
            {
                UVC_MFrame_LastPackLen = 1024;
            }

            UVC_BufInfo.FullFlag[0] = 0x00;
            UVC_BufInfo.Length[0] = (Resolution_width * Resolution_height * 2 / YUV_Totalcount[get_cur[3] - 1] ) +12;
            UVC_BufInfo.FullFlag[1] = 0x00;
            UVC_BufInfo.Length[1] = (Resolution_width * Resolution_height * 2 / YUV_Totalcount[get_cur[3] - 1] ) +12 ;

            USBSS->UEP1_TX_DMA = (UINT32)(UINT8 *)YUV2_addr;
            memcpy( (UINT8 *)( YUV2_addr ),  (uint8_t *)&YUV2, 12 );
            seq = UVC_MFrame_PackCount;
            if( (UVC_MFrame_PackTotalNum >= BURSTMAXSIZE))
            {
                USB30_IN_ClearIT(1);
                USB30_Set_endp_seqnumber(0x81,&seq);
                USB30_IN_Set(1 , 0 , NRDY , BURSTMAXSIZE , 1024  );
            }
            else
            {
                USB30_IN_ClearIT(1);
                USB30_Set_endp_seqnumber(0x81,&seq);
                USB30_IN_Set( 1 , 1 , NRDY , UVC_MFrame_PackTotalNum , UVC_MFrame_LastPackLen );
            }
        }
        else
        {
            YUV2.tog |= 0x02;
            lastFrame=1;
            UVC_MFrame_PackTotalNum = UVC_BufInfo.Length[ UVC_BufInfo.DealNum ] / 1024;
            UVC_MFrame_LastPackLen = UVC_BufInfo.Length[ UVC_BufInfo.DealNum ] % 1024;

            if( UVC_MFrame_LastPackLen )
            {
                UVC_MFrame_PackTotalNum++;
            }
            else if( UVC_MFrame_LastPackLen == 0 )
            {
                UVC_MFrame_LastPackLen = 1024;
            }

            USBSS->UEP1_TX_DMA = (UINT32)(UINT8 *)YUV2_addr;
            memcpy( (UINT8 *)( YUV2_addr ),  (uint8_t *)&YUV2, 12 );
            seq = UVC_MFrame_PackCount;
            if( (UVC_MFrame_PackTotalNum >= BURSTMAXSIZE) )
            {
                USB30_IN_ClearIT(1);
                USB30_Set_endp_seqnumber(0x81,&seq);
                USB30_IN_Set( 1 , 0 , NRDY , BURSTMAXSIZE , 1024  );
            }
            else
            {
                USB30_IN_ClearIT(1);
                USB30_Set_endp_seqnumber(0x81,&seq);
                USB30_IN_Set( 1 , 1 , NRDY , UVC_MFrame_PackTotalNum , UVC_MFrame_LastPackLen  );
            }
        }
    }
}

/*******************************************************************************
 * @fn      endp1_Hander
 *
 * @brief   USB3.0 endpoint 1 processing function
 *
 * @return  None
 */
void Endp1_Hander(void)
{
    UINT8 nump;
    UINT8 seq;
    switch(Formatchange_flag)
    {
        case FORMAT_MJPEG:
                class++;
                MJPEG.Clock = (UINT32)SOURCECLOCK;
                /*Write structure every 8, add one for each IPT , 125us*/
                if(class%8==0)
                {
                    MJPEG.count =(++MJPEG.count)&0x07ff;
                }
                if(fcnt==1)
                {
                    MJPEG.reallen = DVP_SIZE+12;
                        fcnt=2;
                }
                if(end1==1)
                {
                    MJPEG.tog |= 0x02;
                        end1=0;
                        fcnt=0;
                }
                memcpy( endp1RTbuff,  (uint8_t *)&MJPEG,12 );
                USBSS->UEP1_TX_DMA = (UINT32)(UINT8 *)endp1RTbuff;
                USB30_IN_ClearIT(endp_1);
                USB30_IN_Set(endp_1,ENABLE,ACK_TP,NUMP_1,MJPEG.reallen);

                MJPEG.reallen = 12;
                MJPEG.tog &= 0xFD;
            break;
        case FORMAT_YUV2:
         USB30_IN_ClearIT(1);
         nump = USB30_IN_Nump( 1 );
         if( UVC_MFrame_ValidFlag )
         {
             UVC_MFrame_ValidFlag = 0x00;

             UVC_MBuf_PackCount += nump;
             if( UVC_MBuf_PackCount >= UVC_MFrame_PackTotalNum )
             {

                 UVC_MBuf_PackCount -= UVC_MFrame_PackTotalNum;

                 UVC_BufInfo.DealNum++;
                 if( UVC_BufInfo.DealNum >= 2 )
                 {
                     UVC_BufInfo.DealNum = 0x00;
                 }
                 Totalcnt++;
                 if(Totalcnt == YUV_Totalcount[get_cur[3] - 1] - 1)
                 {
                     UVC_BufInfo.FullFlag[UVC_BufInfo.DealNum] = 0x01;
                 }
                 if(Totalcnt == YUV_Totalcount[get_cur[3] - 1])
                 {
                     Totalcnt=0;
                 }
             }

             UVC_MFrame_PackCount += nump;
             if( UVC_MFrame_PackCount < UVC_MFrame_PackTotalNum )
             {
                 USBSS->UEP1_TX_DMA = (UINT32)(UINT8 *)(YUV2_addr+12);
                 packnum = UVC_MFrame_PackTotalNum - UVC_MFrame_PackCount;
                 seq = UVC_MFrame_PackCount;
                 if( packnum >= BURSTMAXSIZE )
                 {
                     USB30_IN_ClearIT(1);
                     USB30_Set_endp_seqnumber(0x81,&seq);
                     USB30_IN_Set( 1 , 0 , NRDY , BURSTMAXSIZE , 1024  );
                 }
                 else
                 {
                     USB30_IN_ClearIT(1);
                     USB30_Set_endp_seqnumber(0x81,&seq);
                     USB30_IN_Set( 1 , 1 , NRDY , packnum , UVC_MFrame_LastPackLen  );
                 }
                 UVC_MFrame_ValidFlag = 0x01;
             }
         }
         break;
    }
}

/*******************************************************************************
 * @fn      endp1_ISOHander_hs
 *
 * @brief   USB2.0 endpoint 1 ISO processing function
 *
 * @return  None
 */
void Endp1_ISOHander_Hs(void)
{
    static UINT32 send_num = 0;
    static UINT8 togGG = 0;
    if( Formatchange_flag == 2)
    {
        if(send_num >= PACKSIZE_3)
        {
            if(togGG == 2)
            {
                togGG = 1;
                R32_UEP1_TX_DMA = (UINT32)(UINT8 *)(YUV2_addr+1024);
                R16_UEP1_T_LEN = 1024;
            }
            else if(togGG == 1)
            {
                togGG = 0 ;
                R32_UEP1_TX_DMA = (UINT32)(UINT8 *)(YUV2_addr+1024);
                R16_UEP1_T_LEN = 1024;

                send_num -= 1024*3-12;
            }
            else if(togGG == 0)
            {
                memcpy( (UINT8 *)( YUV2_addr ),  (uint8_t *)&YUV2, 12 );
                YUV2.tog &= ~(1<<1);
                togGG = 2;
                R32_UEP1_TX_DMA = (UINT32)(UINT8 *)YUV2_addr;
                R16_UEP1_T_LEN = 1024;
            }
        }
        else if(send_num >= PACKSIZE_2 && send_num < PACKSIZE_3)//3 pack
        {
            if(togGG == 2)
            {
                togGG = 1;
                R32_UEP1_TX_DMA = (UINT32)(UINT8 *)(YUV2_addr+1024);
                R16_UEP1_T_LEN = 1024;
            }
            else if(togGG == 1)
            {
                togGG = 0 ;
                R32_UEP1_TX_DMA = (UINT32)(UINT8 *)(YUV2_addr+1024);
                R16_UEP1_T_LEN = send_num - 1024*2 +12;

                send_num = Resolution_width * Resolution_height * 2;
            }
            else if(togGG == 0)
            {
                YUV2.tog |= 0x02;
                YUV2.tog ^= 0x01;
                memcpy( (UINT8 *)( YUV2_addr ),  (uint8_t *)&YUV2, 12 );
                YUV2.tog &= ~(1<<1);
                togGG = 2;
                R32_UEP1_TX_DMA = (UINT32)(UINT8 *)YUV2_addr;
                R16_UEP1_T_LEN = 1024;
            }
        }
        else if(send_num >= PACKSIZE_1 && send_num < PACKSIZE_2)//2 pack
        {
            if(togGG == 1)
            {
                togGG = 0 ;
                R32_UEP1_TX_DMA = (UINT32)(UINT8 *)(YUV2_addr+1024);
                R16_UEP1_T_LEN = send_num - 1024*1 + 12;

                send_num = Resolution_width * Resolution_height * 2;
            }
            else if(togGG == 0)
            {
                YUV2.tog |= 0x02;
                YUV2.tog ^= 0x01;
                memcpy( (UINT8 *)( YUV2_addr ),  (uint8_t *)&YUV2, 12 );
                YUV2.tog &= ~(1<<1);

                togGG = 1;
                R32_UEP1_TX_DMA = (UINT32)(UINT8 *)YUV2_addr;
                R16_UEP1_T_LEN = 1024;
            }
        }
        else
        {
            YUV2.tog |= 0x02;
            YUV2.tog ^= 0x01;
            memcpy( (UINT8 *)( YUV2_addr ),  (uint8_t *)&YUV2, 12 );
            YUV2.tog &= ~(1<<1);

            togGG = 0;
            R32_UEP1_TX_DMA = (UINT32)(UINT8 *)YUV2_addr;
            R16_UEP1_T_LEN = send_num+12;

            send_num = Resolution_width * Resolution_height * 2;
        }
        R8_UEP1_TX_CTRL &= ~(3<<3);
        R8_UEP1_TX_CTRL |= (togGG<<3);
    }

}

/*******************************************************************************
 * @fn      endp1_Hander_hs
 *
 * @brief   USB2.0 endpoint 1 processing function
 *
 * @return  None
 */
void Endp1_Hander_Hs(void)
{

    switch(Formatchange_flag)
    {
        case FORMAT_MJPEG:
                class++;
                MJPEG.Clock = (UINT32)SOURCECLOCK;
                if(class%8==0)
                {
                    //Write structure every 8, add one for each IPT , 125us
                    MJPEG.count =(++MJPEG.count)&0x07ff;
                }
                if(fcnt==1)
                {
                    MJPEG.reallen = DVP_SIZE+12;
                    fcnt=2;
                }
                if(end1==1)
                {
                    MJPEG.tog |= 0x02;
                    end1=0;
                    fcnt=0;
                }
                memcpy( endp1RTbuff,  (uint8_t *)&MJPEG,12 );
                R32_UEP1_TX_DMA = (UINT32)(UINT8 *)endp1RTbuff;
                R16_UEP1_T_LEN =  MJPEG.reallen;

                MJPEG.reallen = 12;
                MJPEG.tog &= 0xFD;
            break;
        case FORMAT_YUV2:
            break;
    }

}

/*******************************************************************************
 * @fn      DVP_Hander
 *
 * @brief   DVP Interrupt processing function
 *
 * @return  None
 */
void DVP_Hander(void){
    UINT32 j;
    /* End of line interrupt */
    if (R8_DVP_INT_FLAG & RB_DVP_IF_ROW_DONE)
    {
        R8_DVP_INT_FLAG = RB_DVP_IF_ROW_DONE;
        if (addr_cnt%2)
        {
            memcpy((UINT8 *)(endp1RTbuff+12),(UINT8 *)JPEG_DVPDMAaddr1,DVP_SIZE);
        }
        else
        {
            memcpy((UINT8 *)(endp1RTbuff+12),(UINT8 *)JPEG_DVPDMAaddr0,DVP_SIZE);
        }
        addr_cnt++;
        fcnt = 1;
    }
    /* Frame reception completion interrupt */
    else if (R8_DVP_INT_FLAG & RB_DVP_IF_FRM_DONE)
    {
        R8_DVP_INT_FLAG = RB_DVP_IF_FRM_DONE;
    }
    /* Frame start interrupt */
    else if (R8_DVP_INT_FLAG & RB_DVP_IF_STR_FRM)
    {
        R8_DVP_INT_FLAG = RB_DVP_IF_STR_FRM;
        start1 =1;
        if(start1&&(UVC_DVP & 0x01)==1){
                MJPEG.tog ^=0x01;
                MJPEG.Frequeny = ~((*(UINT32V *)(0xe000f004)));
                start1 = 0;
                addr_cnt = 0;
        }
    }
    /* Frame end interrupt */
    else if (R8_DVP_INT_FLAG & RB_DVP_IF_STP_FRM)
    {
        R8_DVP_INT_FLAG = RB_DVP_IF_STP_FRM;
        end1=1;
    }
    /* FIFO Overflow interrupt */
    else if (R8_DVP_INT_FLAG & RB_DVP_IF_FIFO_OV)
    {
        R8_DVP_INT_FLAG = RB_DVP_IF_FIFO_OV;
    }
}

