/********************************** (C) COPYRIGHT *******************************
* File Name          : Main.c
* Author             : WCH
* Version            : V1.0
* Date               : 2022/12/07
* Description 		 : main function
* Copyright (c) 2021 Nanjing Qinheng Microelectronics Co., Ltd.
* SPDX-License-Identifier: Apache-2.0
*******************************************************************************/

#include "CH56x_common.h"
#include "ov.h"
#include "dvp.h"
#include "CH56x_usb30.h"
#include "UVCLIB.h"
/*******************************************************************************
 * @fn       DebugInit
 *
 * @brief    Initializes the UART1 peripheral.
 *
 * @param    baudrate: UART1 communication baud rate.
 *
 * @return   None
 */
void DebugInit(UINT32 baudrate)
{
	UINT32 x;
	UINT32 t = FREQ_SYS;
	x = 10 * t * 2 / 16 / baudrate;
	x = ( x + 5 ) / 10;
	R8_UART1_DIV = 1;
	R16_UART1_DL = x;
	R8_UART1_FCR = RB_FCR_FIFO_TRIG | RB_FCR_TX_FIFO_CLR | RB_FCR_RX_FIFO_CLR | RB_FCR_FIFO_EN;
	R8_UART1_LCR = RB_LCR_WORD_SZ;
	R8_UART1_IER = RB_IER_TXD_EN;
	R32_PA_SMT |= (1<<8) |(1<<7);
	R32_PA_DIR |= (1<<8);
}

/*********************************************************************
 * @fn      main
 *
 * @brief   Main program.
 *
 * @return  none
 */
int main()
{

	SystemInit(FREQ_SYS);
	Delay_Init(FREQ_SYS);

	/* Configure uart debugging */
	DebugInit(921600);
	PRINT("UVC Program(120MHz) !\n");

	/*Initialize camera*/
	while(OV2640_Init())//Initialize OV2640
	{
		PRINT("Camera model Err\r\n");
		mDelaymS(500);
	}

	JPEG_Mode_Init();
	mDelaymS(200);

	dvp_Init();//Initialize DVP
	FillYUVdata();

	R32_USB_CONTROL = 0;
    PFIC_EnableIRQ(USBSS_IRQn);
    PFIC_EnableIRQ(LINK_IRQn);
    PFIC_EnableIRQ( TMR0_IRQn );
    TMR0_TimerInit( 67000000 );
    USB30D_init(ENABLE);

	while(1);
}


